/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.ErrorHandler;
import org.davidmoten.oa3.codegen.spring.runtime.RequestPreconditions;
import org.davidmoten.oa3.codegen.spring.runtime.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

public final class ServerCodeWriterSpringBoot {
    public static void writeServiceClasses(Names names, List<ClientServerGenerator.Method> methods) {
        ServerCodeWriterSpringBoot.writeApplicationClass(names);
        ServerCodeWriterSpringBoot.writeJacksonConfigurationClass(names);
        List<ClientServerGenerator.Method> includedMethods = methods.stream().filter(x -> x.includeForServerGeneration).collect(Collectors.toList());
        ServerCodeWriterSpringBoot.writeServiceControllerClass(names, includedMethods);
        ServerCodeWriterSpringBoot.writeServiceInterfaceClass(names, includedMethods);
    }

    private static void writeApplicationClass(Names names) {
        CodePrintWriter out = CodePrintWriter.create(names.applicationFullClassName());
        ServerCodeWriterSpringBoot.writeApplicationClass(out);
        WriterUtil.writeContent(names, out);
    }

    private static void writeApplicationClass(CodePrintWriter out) {
        out.line("package %s;", out.pkg());
        out.println();
        out.format("%s", "IMPORTS_HERE");
        out.println();
        out.line("@%s", SpringBootApplication.class);
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public class %s {", out.simpleClassName());
        out.println();
        out.line("public static void main(%s[] args) {", String.class);
        out.line("%s.run(%s.class, args);", SpringApplication.class, out.simpleClassName());
        out.closeParen();
        out.left();
        out.println();
        out.line("}", new Object[0]);
    }

    private static void writeJacksonConfigurationClass(Names names) {
        String fullClassName = names.jacksonConfigurationFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName);
        ServerCodeWriterSpringBoot.writeJacksonConfigurationClass(out, names);
        WriterUtil.writeContent(names, out);
    }

    private static void writeJacksonConfigurationClass(CodePrintWriter out, Names names) {
        out.line("package %s;", out.pkg());
        out.println();
        out.format("%s", "IMPORTS_HERE");
        out.println();
        out.line("@%s", Configuration.class);
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public class %s {", out.simpleClassName());
        out.println();
        out.line("private final %s config;", Config.class);
        out.println();
        out.line("public %s(@%s(required = false) %s config) {", out.simpleClassName(), Autowired.class, Config.class);
        out.line("this.config = config == null ? %s.config() : config;", out.add(names.globalsFullClassName()));
        out.closeParen();
        out.println();
        out.line("@%s", Bean.class);
        out.line("@%s", Primary.class);
        out.line("public %s objectMapper() {", ObjectMapper.class);
        out.line("return config.mapper();", new Object[0]);
        out.closeParen();
        out.left();
        out.println();
        out.line("}", new Object[0]);
    }

    private static void writeServiceControllerClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.serviceControllerFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName);
        ServerCodeWriterSpringBoot.writeServiceControllerClass(out, names, methods);
        WriterUtil.writeContent(names, out);
    }

    private static void writeServiceInterfaceClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.serviceInterfaceFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName);
        ServerCodeWriterSpringBoot.writeServiceInterfaceClass(out, names, methods);
        WriterUtil.writeContent(names, out);
    }

    private static void writeServiceInterfaceClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", out.pkg());
        out.println();
        out.format("%s", "IMPORTS_HERE");
        WriterUtil.writeApiJavadoc(out, names);
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public interface %s extends %s {", out.simpleClassName(), ErrorHandler.class);
        ServerCodeWriterSpringBoot.writeServiceMethods(out, methods, false, names);
        out.closeParen();
    }

    private static void writeServiceControllerClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", out.pkg());
        out.println();
        out.format("%s", "IMPORTS_HERE");
        out.println();
        out.line("@%s", RestController.class);
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public class %s implements %s {", out.simpleClassName(), ControllerExceptionHandler.class);
        out.println();
        out.line("private final %s service;", out.add(names.serviceInterfaceFullClassName()));
        out.println();
        out.line("public %s(@%s(required = false) %s service) {", out.simpleClassName(), Autowired.class, out.add(names.serviceInterfaceFullClassName()));
        out.line("this.service = %s.orElse(service, new %s() {});", org.davidmoten.oa3.codegen.util.Util.class, out.add(names.serviceInterfaceFullClassName()));
        out.closeParen();
        ServerCodeWriterSpringBoot.writeServiceMethods(out, methods, true, names);
        out.closeParen();
    }

    private static void writeServiceMethods(CodePrintWriter out, List<ClientServerGenerator.Method> methods, boolean isController, Names names) {
        methods.forEach(m -> {
            Optional<String> returns = m.returnFullClassName.isPresent() ? m.primaryStatusCode.map(x -> "primary response status code " + x) : Optional.empty();
            ServerCodeWriterSpringBoot.writeMethodJavadoc(out, m, returns);
            out.right().right();
            String params = m.parameters.stream().map(p -> {
                String annotations;
                if (p.isRequestBody) {
                    String annotations2 = isController ? String.format("@%s ", out.add(RequestBody.class)) : "";
                    return String.format("\n%s%s%s %s", out.indent(), annotations2, ServerCodeWriterSpringBoot.toImportedType(p, out.imports()), "requestBody");
                }
                if (isController) {
                    String defValue = p.defaultValue.map(x -> ", defaultValue = \"" + x + "\"").orElse("");
                    String required = ", required = " + p.required;
                    Class<Object> ann = ServerCodeWriterSpringBoot.annotation(p.type);
                    if (ann.equals(RequestParam.class) && p.isComplexQueryParameter) {
                        ann = ModelAttribute.class;
                        required = "";
                        defValue = "";
                    }
                    annotations = String.format("@%s(name = \"%s\"%s%s) ", out.add(ann), p.name, defValue, required);
                } else {
                    annotations = "";
                }
                return String.format("\n%s%s%s %s", out.indent(), annotations, ServerCodeWriterSpringBoot.toImportedType(p, out.imports()), p.identifier);
            }).collect(Collectors.joining(", "));
            out.left().left();
            String importedReturnType = isController ? String.format("%s<?>", out.add(ResponseEntity.class)) : (!m.returnFullClassName.isPresent() ? "void" : out.add(m.returnFullClassName.get()));
            if (isController) {
                String produces;
                out.line("@%s(", RequestMapping.class);
                out.right();
                String consumes = m.consumes.stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
                if (!consumes.isEmpty()) {
                    consumes = String.format(",\n%sconsumes = {%s}", out.indent(), consumes);
                }
                if (!(produces = m.produces.stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", "))).isEmpty()) {
                    produces = String.format(",\n%sproduces = {%s}", out.indent(), produces);
                }
                out.line("method = %s.%s,", RequestMethod.class, m.httpMethod);
                out.line("value = \"%s\"%s%s)", m.path, consumes, produces);
                out.left();
                out.line("public %s %s(%s) {", importedReturnType, m.methodName, params);
                out.line("try {", new Object[0]);
                ServerCodeWriterSpringBoot.addValidationChecks(out, m, names);
                if (m.returnFullClassName.isPresent()) {
                    out.line("return %s.status(%s).body(service.%s(%s));", ResponseEntity.class, m.statusCode.get(), m.methodName, m.parameters.stream().map(p -> p.identifier).collect(Collectors.joining(", ")));
                } else {
                    out.line("service.%s(%s);", m.methodName, m.parameters.stream().map(p -> p.identifier).collect(Collectors.joining(", ")));
                    out.line("return %s.status(%s).build();", ResponseEntity.class, m.statusCode.orElse(200));
                }
                out.left();
                out.line("} catch (%s e) {", Throwable.class);
                out.line("return service.errorResponse(e);", new Object[0]);
                out.closeParen();
                out.closeParen();
            } else {
                out.line("default %s %s(%s) throws %s {", importedReturnType, m.methodName, params, ServiceException.class);
                out.line("throw notImplemented();", new Object[0]);
                out.closeParen();
            }
        });
    }

    static void writeMethodJavadoc(CodePrintWriter out, ClientServerGenerator.Method m, Optional<String> returns) {
        Map<String, String> parameterDescriptions = m.parameters.stream().collect(Collectors.toMap(x -> x.identifier, x -> x.description.orElse(x.identifier).replace("\\n\\s*", " ").replace("&", "&amp;").replace("/", "&#47;").replace("<", "&lt;").replace(">", "&gt;")));
        String html = m.description.map(x -> WriterUtil.markdownToHtml(x)).orElse("<p>Returns response from call to path <i>%s</i>.</p>");
        String more = m.responseDescriptors.stream().map(rd -> {
            String full = rd.fullClassName();
            String link = Util.isPrimitiveFullClassName(full) || full.equals("byte[]") ? full : String.format("{@link %s}", out.add(full));
            return String.format("\n<p>[status=%s, %s] --&gt; %s</p>", rd.statusCode(), rd.mediaType(), link);
        }).collect(Collectors.joining());
        if (!Javadoc.printJavadoc(out, Optional.of(html + more), Collections.emptyList(), Optional.empty(), returns, parameterDescriptions, true)) {
            out.println();
        }
    }

    private static Class<?> annotation(ParamType t) {
        if (t == ParamType.BODY) {
            return RequestBody.class;
        }
        if (t == ParamType.QUERY) {
            return RequestParam.class;
        }
        if (t == ParamType.PATH) {
            return PathVariable.class;
        }
        if (t == ParamType.HEADER) {
            return RequestHeader.class;
        }
        if (t == ParamType.COOKIE) {
            return CookieValue.class;
        }
        throw new IllegalArgumentException("unexpected " + (Object)((Object)t));
    }

    private static void addValidationChecks(CodePrintWriter out, ClientServerGenerator.Method m, Names names) {
        boolean found = m.parameters.stream().anyMatch(p -> p.constraints.atLeastOnePresent());
        if (found) {
            out.line("if (%s.config().validateInControllerMethod().test(\"%s\")) {", out.add(names.globalsFullClassName()), m.methodName);
            m.parameters.forEach(p -> {
                ClientServerGenerator.Constraints x = p.constraints;
                if (x.atLeastOnePresent()) {
                    if (x.minLength.isPresent()) {
                        out.line("%s.checkMinLength(%s, %s, \"%s\");", RequestPreconditions.class, p.identifier, x.minLength.get(), p.identifier);
                    }
                    if (x.maxLength.isPresent()) {
                        out.line("%s.checkMaxLength(%s, %s, \"%s\");", RequestPreconditions.class, p.identifier, x.maxLength.get(), p.identifier);
                    }
                    if (x.pattern.isPresent()) {
                        out.line("%s.checkMatchesPattern(%s, \"%s\", \"%s\");", RequestPreconditions.class, p.identifier, WriterUtil.escapePattern(x.pattern.get()), p.identifier);
                    }
                    if (x.min.isPresent()) {
                        out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", RequestPreconditions.class, p.identifier, x.min.get().toString(), p.identifier, false);
                    }
                    if (x.max.isPresent()) {
                        out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", RequestPreconditions.class, p.identifier, x.max.get().toString(), p.identifier, false);
                    }
                    if (x.minExclusive.isPresent()) {
                        out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", RequestPreconditions.class, p.identifier, x.minExclusive.get().toString(), p.identifier, true);
                    }
                    if (x.maxExclusive.isPresent()) {
                        out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", RequestPreconditions.class, p.identifier, x.maxExclusive.get().toString(), p.identifier, true);
                    }
                    if (p.isArray && x.minItems.isPresent()) {
                        out.line("%s.checkMinSize(%s, %s, \"%s\");", RequestPreconditions.class, p.identifier, x.minItems.get(), p.identifier);
                    }
                    if (p.isArray && x.maxItems.isPresent()) {
                        out.line("%s.checkMaxSize(%s, %s, \"%s\");", RequestPreconditions.class, p.identifier, x.maxItems.get(), p.identifier);
                    }
                }
            });
            out.closeParen();
        }
    }

    static String toImportedType(ClientServerGenerator.Param p, Imports imports) {
        if (p.isArray) {
            if (p.required) {
                return String.format("%s<%s>", imports.add(List.class), imports.add(p.fullClassName));
            }
            return String.format("%s<%s<%s>>", imports.add(Optional.class), imports.add(List.class), imports.add(p.fullClassName));
        }
        if (p.required || p.defaultValue.isPresent()) {
            return imports.add(Util.toPrimitive(p.fullClassName));
        }
        return String.format("%s<%s>", imports.add(Optional.class), imports.add(p.fullClassName));
    }
}

