/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.davidmoten.guavamini.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.ServerGeneratorType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;
import org.davidmoten.oa3.codegen.generator.internal.Mutable;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.generator.writer.BuilderWriter;
import org.davidmoten.oa3.codegen.http.HasEncoding;
import org.davidmoten.oa3.codegen.http.HasStringValue;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.davidmoten.oa3.codegen.runtime.DiscriminatorHelper;
import org.davidmoten.oa3.codegen.runtime.NullEnumDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.util.Util;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.boot.context.properties.ConstructorBinding;

public final class SchemasCodeWriter {
    private SchemasCodeWriter() {
    }

    public static void writeSchemaClass(Names names, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Generator.Cls cls, String schemaName) {
        if ((cls.category == SchemaCategory.PATH || cls.category == SchemaCategory.RESPONSE) && cls.schema.isPresent() && cls.schema.get().get$ref() != null) {
            return;
        }
        CodePrintWriter out = CodePrintWriter.create(cls.fullClassName);
        SchemasCodeWriter.writeClass(out, cls, fullClassNameInterfaces, names);
        WriterUtil.writeContent(names, out);
    }

    public static void writeGlobalsClass(Names names) {
        String fullClassName = names.globalsFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName);
        out.line("package %s;", Names.pkg(fullClassName));
        out.println();
        out.format("%s", "IMPORTS_HERE");
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public final class %s {", Names.simpleClassName(fullClassName));
        out.println();
        out.line("private static volatile %s config = %s.builder().build();", Config.class, Config.class);
        out.println();
        out.line("public static void setConfig(%s configuration) {", Config.class);
        out.line("config = configuration;", new Object[0]);
        out.closeParen();
        out.println();
        out.line("public static %s config() {", Config.class);
        out.line("return config;", new Object[0]);
        out.closeParen();
        out.closeParen();
        WriterUtil.writeContent(names, out);
    }

    private static void writeClass(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        if (cls.topLevel) {
            out.line("package %s;", cls.pkg());
            out.println();
            out.format("%s", "IMPORTS_HERE");
        }
        SchemasCodeWriter.reserveMemberClassNamesInImports(out.imports(), cls);
        SchemasCodeWriter.writeClassDeclaration(out, cls, fullClassNameInterfaces);
        SchemasCodeWriter.writeEnumMembers(out, cls);
        if (SchemasCodeWriter.isPolymorphic(cls)) {
            SchemasCodeWriter.writePolymorphicClassContent(out, cls, names, fullClassNameInterfaces);
        } else {
            SchemasCodeWriter.writeFields(out, cls);
            SchemasCodeWriter.writeConstructor(out, cls, fullClassNameInterfaces, names);
            SchemasCodeWriter.writeBuilder(out, cls, fullClassNameInterfaces);
            SchemasCodeWriter.writeGetters(out, cls, fullClassNameInterfaces);
            SchemasCodeWriter.writePropertiesMapGetter(out, cls);
            SchemasCodeWriter.writeMutators(out, cls, fullClassNameInterfaces);
        }
        SchemasCodeWriter.writeEnumCreator(out, cls);
        SchemasCodeWriter.writeEnumDeserializer(out, cls);
        SchemasCodeWriter.writeMemberClasses(out, cls, fullClassNameInterfaces, names);
        if (cls.classType != Generator.ClassType.ENUM && cls.classType != Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            SchemasCodeWriter.writeEqualsMethod(out, cls);
            SchemasCodeWriter.writeHashCodeMethod(out, cls);
            SchemasCodeWriter.writeToStringMethod(out, cls);
        }
        out.closeParen();
    }

    private static void reserveMemberClassNamesInImports(Imports imports, Generator.Cls cls) {
        if (cls.classes.isEmpty()) {
            return;
        }
        cls.classes.forEach(c -> SchemasCodeWriter.reserveMemberClassNamesInImports(imports, c));
        cls.classes.forEach(c -> imports.add(c.fullClassName));
    }

    private static boolean isPolymorphic(Generator.Cls cls) {
        return cls.classType == Generator.ClassType.ONE_OR_ANY_OF_NON_DISCRIMINATED || cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED || cls.classType == Generator.ClassType.ALL_OF;
    }

    private static void addOverrideAnnotation(CodePrintWriter out) {
        out.println();
        out.line("@%s", Override.class);
    }

    private static void writeEnumCreator(CodePrintWriter out, Generator.Cls cls) {
        if (cls.classType == Generator.ClassType.ENUM) {
            String simpleClassName = Names.simpleClassName(cls.fullClassName);
            out.println();
            out.line("@%s", JsonCreator.class);
            out.line("public static %s fromValue(%s value) {", simpleClassName, Object.class);
            out.line("for (%s x: %s.values()) {", simpleClassName, simpleClassName);
            if (cls.isNullableEnum()) {
                out.line("if (%s.equals(value, x.value.get())) {", Objects.class);
            } else {
                out.line("if (%s.equals(value, x.value)) {", Objects.class);
            }
            out.line("return x;", new Object[0]);
            out.closeParen();
            out.closeParen();
            out.line("throw new %s(\"unexpected enum value: '\" + value + \"'\");", IllegalArgumentException.class);
            out.closeParen();
        }
    }

    private static void writeEnumDeserializer(CodePrintWriter out, Generator.Cls cls) {
        if (cls.hasEnumNullValue()) {
            String nullValueMemberName = cls.enumMembers.stream().filter(x -> x.parameter == null).map(x -> x.name).findFirst().get();
            out.println();
            out.line("public static class Deserializer extends %s<%s> {", NullEnumDeserializer.class, cls.simpleName());
            out.line("protected Deserializer() {", new Object[0]);
            out.line("super(%s.class, %s.class, %s);", cls.simpleName(), out.add(cls.enumValueFullType), nullValueMemberName);
            out.closeParen();
            out.closeParen();
        }
    }

    private static void writeClassDeclaration(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        String modifier = SchemasCodeWriter.classModifier(cls);
        Set<Generator.Cls> interfaces = fullClassNameInterfaces.get(cls.fullClassName);
        String implementsClause = SchemasCodeWriter.implementsClause(out.imports(), interfaces, cls);
        boolean javadocExists = cls.description.isPresent() ? Javadoc.printJavadoc(out, out.indent(), cls.description.get(), false) : false;
        if (!javadocExists) {
            out.println();
        }
        if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            SchemasCodeWriter.writeJsonTypeInfoAnnotation(out, cls);
        } else if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_NON_DISCRIMINATED || cls.classType == Generator.ClassType.ALL_OF) {
            SchemasCodeWriter.writePolymorphicDeserializerAnnotation(out, cls);
        }
        if (cls.classType != Generator.ClassType.ENUM && cls.classType != Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            SchemasCodeWriter.writeJsonIncludeAnnotation(out);
            SchemasCodeWriter.writeAutoDetectAnnotation(out);
        }
        if (cls.classType == Generator.ClassType.ENUM && cls.hasEnumNullValue()) {
            SchemasCodeWriter.writeEnumNullValueDeserializerAnnotation(out, cls);
        }
        if (cls.topLevel) {
            WriterUtil.addGeneratedAnnotation(out);
        }
        out.line("public %s%s %s%s {", modifier, cls.classType.word(), cls.simpleName(), implementsClause);
    }

    private static void writeEnumNullValueDeserializerAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(using = %s.Deserializer.class)", JsonDeserialize.class, cls.simpleName());
    }

    private static void writeJsonIncludeAnnotation(CodePrintWriter out) {
        out.line("@%s(%s.NON_NULL)", JsonInclude.class, JsonInclude.Include.class);
    }

    private static String classModifier(Generator.Cls cls) {
        String modifier = cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED || cls.classType == Generator.ClassType.ENUM ? "" : (cls.topLevel ? "final " : "static final ");
        return modifier;
    }

    private static String implementsClause(Imports imports, Set<Generator.Cls> interfaces, Generator.Cls cls) {
        String implemented;
        if ((interfaces = (Set)Util.orElse(interfaces, Collections.emptySet())).isEmpty() && !cls.hasEncoding()) {
            implemented = "";
        } else {
            Stream<String> a = interfaces.stream().map(x -> x.fullClassName);
            Stream<String> b = Stream.of(HasEncoding.class.getCanonicalName()).filter(x -> cls.hasEncoding() && cls.classType != Generator.ClassType.ENUM);
            Stream<String> c = Stream.of(HasStringValue.class.getCanonicalName()).filter(x -> cls.hasEncoding() && cls.classType == Generator.ClassType.ENUM);
            implemented = " implements " + Stream.concat(a, Stream.concat(b, c)).map(x -> imports.add((String)x)).collect(Collectors.joining(", "));
        }
        return implemented;
    }

    private static void writeJsonTypeInfoAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(use = %s.NAME, property = \"%s\", include = %s.EXISTING_PROPERTY, visible = true)", JsonTypeInfo.class, JsonTypeInfo.Id.class, cls.discriminator.propertyName, JsonTypeInfo.As.class);
        out.right().right();
        String types = cls.fields.stream().map(x -> {
            String fieldImportedType = x.fullClassName.startsWith(cls.fullClassName) ? Names.simpleClassName(cls.fullClassName) + x.fullClassName.substring(cls.fullClassName.length()) : out.add(x.fullClassName);
            return String.format("\n%s@%s(value = %s.class, name = \"%s\")", out.indent(), out.add(JsonSubTypes.Type.class), fieldImportedType, cls.discriminator.discriminatorValueFromFullClassName(x.fullClassName));
        }).collect(Collectors.joining(", "));
        out.left().left();
        out.line("@%s({%s})", JsonSubTypes.class, types);
    }

    private static void addConstructorBindingAnnotation(CodePrintWriter out, Names names) {
        if (names.generatorType() == ServerGeneratorType.SPRING3) {
            out.line("@%s", out.add(ConstructorBinding.class.getName().replace("ConstructorBinding", "bind.ConstructorBinding")));
        } else {
            out.line("@%s", ConstructorBinding.class);
        }
    }

    private static void writePolymorphicDeserializerAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(using = %s.Deserializer.class)", JsonDeserialize.class, cls.simpleName());
    }

    private static void writeAutoDetectAnnotation(CodePrintWriter out) {
        out.line("@%s(fieldVisibility = %s.ANY, creatorVisibility = %s.ANY, setterVisibility = %s.ANY)", JsonAutoDetect.class, JsonAutoDetect.Visibility.class, JsonAutoDetect.Visibility.class, JsonAutoDetect.Visibility.class);
    }

    private static void writeEnumMembers(CodePrintWriter out, Generator.Cls cls) {
        String parameterFullClassName = !cls.fields.isEmpty() ? cls.fields.get((int)0).fullClassName : "NotUsed";
        String text = cls.enumMembers.stream().map(x -> {
            String delim;
            if (parameterFullClassName.equals(BigInteger.class.getCanonicalName()) || parameterFullClassName.equals(BigDecimal.class.getCanonicalName())) {
                return String.format("%s%s(new %s(\"\"))", out.indent(), x.name, out.add(parameterFullClassName), x.parameter);
            }
            String string = delim = x.parameter instanceof String ? "\"" : "";
            if (x.nullable) {
                return String.format("%s%s(%s.of(%s%s%s))", out.indent(), x.name, out.add(JsonNullable.class), delim, x.parameter, delim);
            }
            return String.format("%s%s(%s%s%s)", out.indent(), x.name, delim, x.parameter, delim);
        }).collect(Collectors.joining(",\n"));
        if (!text.isEmpty()) {
            out.println("\n" + text + ";");
        }
    }

    private static void writePolymorphicClassContent(CodePrintWriter out, Generator.Cls cls, Names names, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            out.println();
            out.line("%s %s();", String.class, cls.discriminator.fieldName);
        } else {
            if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_NON_DISCRIMINATED) {
                out.println();
                SchemasCodeWriter.writeJsonValueAnnotation(out);
                out.line("private final %s %s;", Object.class, "value");
                SchemasCodeWriter.writeOneOfAnyOfNonDiscriminatedObjectConstructor(out, cls);
                cls.fields.forEach(f -> SchemasCodeWriter.writeOneOfAnyOfNonDiscriminatedMemberSpecificConstructor(out, cls, f));
                SchemasCodeWriter.writeNonDiscriminatedBuilder(out, cls);
                out.println();
                SchemasCodeWriter.writeGetter(out, out.add(Object.class), "value", "value");
            } else {
                SchemasCodeWriter.writeFields(out, cls);
                out.right().right();
                String parametersNullable = cls.fields.stream().map(x -> String.format("\n%s%s %s", out.indent(), x.resolvedTypeNullable(out.imports()), x.fieldName(cls))).collect(Collectors.joining(","));
                out.left().left();
                out.println();
                out.line("public %s(%s) {", Names.simpleClassName(cls.fullClassName), parametersNullable);
                SchemasCodeWriter.ifValidate(cls, out, names, o -> cls.fields.stream().forEach(x -> {
                    if (!x.isPrimitive() && x.required) {
                        SchemasCodeWriter.checkNotNull(cls, o, x);
                    } else {
                        o.line("// TODO %s", x.fieldName);
                    }
                    SchemasCodeWriter.validateMore(o, cls, x);
                }));
                cls.fields.stream().forEach(x -> SchemasCodeWriter.assignField(out, cls, x));
                out.closeParen();
                SchemasCodeWriter.writeAllOfBuilder(out, cls);
                SchemasCodeWriter.writeGetters(out, cls, fullClassNameInterfaces);
            }
            out.println();
            out.line("@%s(\"serial\")", SuppressWarnings.class);
            out.line("public static final class Deserializer extends %s<%s> {", PolymorphicDeserializer.class, cls.simpleName());
            out.println();
            out.line("public Deserializer() {", new Object[0]);
            String classes = cls.fields.stream().map(x -> out.add(org.davidmoten.oa3.codegen.generator.internal.Util.toPrimitive(x.fullClassName)) + ".class").collect(Collectors.joining(", "));
            out.line("super(%s.config(), %s.%s, %s.class, %s);", out.add(names.globalsFullClassName()), PolymorphicType.class, cls.polymorphicType.name(), cls.simpleName(), classes);
            out.closeParen();
            out.closeParen();
        }
    }

    private static void writeAllOfBuilder(CodePrintWriter out, Generator.Cls cls) {
        List<BuilderWriter.Field> fields = cls.fields.stream().map(f -> new BuilderWriter.Field(f.fieldName(cls), f.fullClassName, f.required, f.isArray, f.mapType, f.nullable)).collect(Collectors.toList());
        BuilderWriter.write(out, fields, cls.simpleName());
    }

    private static void writeNonDiscriminatedBuilder(CodePrintWriter out, Generator.Cls cls) {
        cls.fields.forEach(f -> {
            out.line("public static %s of(%s value) {", cls.simpleName(), out.add(f.fullClassName));
            out.line("return new %s(value);", cls.simpleName());
            out.closeParen();
        });
    }

    private static void writeOneOfAnyOfNonDiscriminatedMemberSpecificConstructor(CodePrintWriter out, Generator.Cls cls, Generator.Field f) {
        String className = org.davidmoten.oa3.codegen.generator.internal.Util.toPrimitive(f.fullClassName);
        out.println();
        out.line("public %s(%s value) {", cls.simpleName(), out.add(className));
        if (org.davidmoten.oa3.codegen.generator.internal.Util.isPrimitiveFullClassName(className)) {
            out.line("this.value = value;", new Object[0]);
        } else {
            out.line("this.value = %s.checkNotNull(value, \"value\");", Preconditions.class);
        }
        out.closeParen();
    }

    private static void writeOneOfAnyOfNonDiscriminatedObjectConstructor(CodePrintWriter out, Generator.Cls cls) {
        out.println();
        out.line("@%s", JsonCreator.class);
        out.line("private %s(%s value) {", cls.simpleName(), Object.class);
        out.line("this.value = %s.checkNotNull(value, \"value\");", Preconditions.class);
        out.closeParen();
    }

    private static void writeFields(CodePrintWriter out, Generator.Cls cls) {
        if (!cls.fields.isEmpty()) {
            out.println();
        }
        Mutable<Boolean> first = Mutable.create(true);
        cls.fields.forEach(f -> {
            if (!((Boolean)first.value).booleanValue()) {
                out.println();
            }
            first.value = false;
            if (f.isAdditionalProperties() && !f.isArray) {
                out.line("@%s", JsonAnyGetter.class);
                out.line("@%s", JsonAnySetter.class);
            } else if (cls.classType == Generator.ClassType.ALL_OF) {
                out.line("@%s", JsonUnwrapped.class);
            } else if (cls.unwrapSingleField()) {
                SchemasCodeWriter.writeJsonValueAnnotation(out);
            } else {
                out.line("@%s(\"%s\")", JsonProperty.class, f.name);
            }
            String fieldType = f.mapType.isPresent() ? f.resolvedTypeMapPrivate(out.imports()) : (f.encoding == Generator.Encoding.OCTET ? out.add(String.class) : f.resolvedTypeNullable(out.imports()));
            out.line("private final %s %s;", fieldType, cls.fieldName((Generator.Field)f));
        });
    }

    private static void writeJsonValueAnnotation(CodePrintWriter out) {
        out.line("@%s", JsonValue.class);
    }

    private static void writeConstructor(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        String visibility;
        out.right().right();
        String parametersNullable = cls.unwrapSingleField() ? cls.fields.stream().map(x -> String.format("\n%s%s %s", out.indent(), x.resolvedTypeNullable(out.imports()), x.fieldName(cls))).collect(Collectors.joining(",")) : cls.fields.stream().filter(x -> !x.isAdditionalProperties()).map(x -> String.format("\n%s@%s(\"%s\") %s %s", out.indent(), out.add(JsonProperty.class), x.name, x.resolvedTypeNullable(out.imports()), x.fieldName(cls))).collect(Collectors.joining(","));
        out.left().left();
        Set<Generator.Cls> interfaces = SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces);
        out.println();
        if (cls.classType != Generator.ClassType.ENUM) {
            out.line("@%s", JsonCreator.class);
        }
        boolean hasOptional = cls.fields.stream().anyMatch(f -> !f.required && (!f.nullable || f.isArray) && !f.isMapType(Generator.MapType.FIELD) || f.required && f.nullable && !f.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES) && !f.isArray || !f.nullable && !f.required && f.isMapType(Generator.MapType.FIELD));
        boolean hasBinary = cls.fields.stream().anyMatch(Generator.Field::isOctets);
        String string = visibility = cls.classType == Generator.ClassType.ENUM || hasOptional || hasBinary || !interfaces.isEmpty() ? "private" : "public";
        if (visibility.equals("public")) {
            SchemasCodeWriter.addConstructorBindingAnnotation(out, names);
        }
        out.line("%s %s(%s) {", visibility, Names.simpleClassName(cls.fullClassName), parametersNullable);
        SchemasCodeWriter.ifValidate(cls, out, names, out2 -> cls.fields.stream().filter(x -> !x.isAdditionalProperties()).forEach(x -> {
            if (!x.isPrimitive() && x.required && !visibility.equals("private")) {
                SchemasCodeWriter.checkNotNull(cls, out2, x);
            }
            SchemasCodeWriter.validateMore(out2, cls, x);
        }));
        cls.fields.stream().forEach(x -> {
            if (x.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
                if (x.isArray) {
                    out.line("this.%s = new %s<>();", x.fieldName(cls), ArrayList.class);
                } else {
                    out.line("this.%s = new %s<>();", x.fieldName(cls), HashMap.class);
                }
            } else {
                SchemasCodeWriter.assignField(out, cls, x);
            }
        });
        out.closeParen();
        boolean hasAdditionalProperties = cls.fields.stream().anyMatch(Generator.Field::isAdditionalProperties);
        if (cls.classType != Generator.ClassType.ENUM && (hasOptional || !interfaces.isEmpty() || hasBinary || hasAdditionalProperties)) {
            out.right().right();
            String parametersOptional = cls.fields.stream().filter(x -> !SchemasCodeWriter.isDiscriminator(interfaces, x)).filter(x -> !x.isAdditionalProperties() || !x.isArray).map(x -> {
                String t = x.mapType.isPresent() ? x.resolvedTypeMapPublic(out.imports()) : x.resolvedTypePublicConstructor(out.imports());
                return String.format("\n%s%s %s", out.indent(), t, x.fieldName(cls));
            }).collect(Collectors.joining(","));
            out.left().left();
            out.println();
            SchemasCodeWriter.addConstructorBindingAnnotation(out, names);
            String modifier = cls.classType == Generator.ClassType.ENUM ? "private" : "public";
            out.line("%s %s(%s) {", modifier, Names.simpleClassName(cls.fullClassName), parametersOptional);
            SchemasCodeWriter.ifValidate(cls, out, names, out2 -> cls.fields.stream().filter(x -> !x.isAdditionalProperties()).forEach(x -> {
                if (!SchemasCodeWriter.isDiscriminator(interfaces, x) && (x.isOctets() || !x.isPrimitive() && !x.isByteArray())) {
                    SchemasCodeWriter.checkNotNull(cls, out2, x);
                    SchemasCodeWriter.validateMore(out2, cls, x);
                }
            }));
            cls.fields.stream().forEach(x -> {
                if (x.mapType.isPresent()) {
                    if (x.isArray) {
                        if (x.nullable) {
                            out.line("this.%s = %s.of(new %s<>());", x.fieldName(cls), JsonNullable.class, ArrayList.class);
                        } else {
                            out.line("this.%s = new %s<>();", x.fieldName(cls), ArrayList.class);
                        }
                    } else if (x.nullable && !x.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
                        if (x.required) {
                            out.line("this.%s = %s.of(%s.orElse(null));", x.fieldName(cls), JsonNullable.class, x.fieldName(cls));
                        } else {
                            out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
                        }
                    } else if (x.required) {
                        out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
                    } else {
                        out.line("this.%s = %s.orElse(null);", x.fieldName(cls), x.fieldName(cls));
                    }
                    return;
                }
                Optional<Generator.Discriminator> disc = SchemasCodeWriter.discriminator(interfaces, x);
                if (disc.isPresent()) {
                    out.line("this.%s = %s.value(%s.class, \"%s\");", x.fieldName(cls), DiscriminatorHelper.class, out.add(x.fullClassName), disc.get().discriminatorValueFromFullClassName(cls.fullClassName));
                } else if (x.nullable) {
                    if (x.required) {
                        out.line("this.%s = %s.of(%s.orElse(null));", x.fieldName(cls), JsonNullable.class, x.fieldName(cls));
                    } else {
                        SchemasCodeWriter.assignField(out, cls, x);
                    }
                } else if (x.isOctets()) {
                    SchemasCodeWriter.assignEncodedOctets(out, cls, x);
                } else if (!x.isPrimitive()) {
                    if (x.required) {
                        SchemasCodeWriter.assignField(out, cls, x);
                    } else {
                        SchemasCodeWriter.assignOptionalField(out, cls, x);
                    }
                } else {
                    SchemasCodeWriter.assignField(out, cls, x);
                }
            });
            out.closeParen();
        }
    }

    private static Set<Generator.Cls> interfaces(Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        Set interfaces = (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
        return interfaces;
    }

    private static void writeBuilder(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        if (cls.classType == Generator.ClassType.ENUM) {
            return;
        }
        Set interfaces = (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
        List<BuilderWriter.Field> fields = cls.fields.stream().filter(x -> !SchemasCodeWriter.isDiscriminator(interfaces, x)).map(f -> new BuilderWriter.Field(f.fieldName(cls), f.fullClassName, f.required && !f.isAdditionalProperties(), f.isArray, f.mapType, f.nullable)).collect(Collectors.toList());
        BuilderWriter.write(out, fields, cls.simpleName());
    }

    private static void checkNotNull(Generator.Cls cls, CodePrintWriter out, Generator.Field x) {
        out.line("%s.checkNotNull(%s, \"%s\");", Preconditions.class, x.fieldName(cls), x.fieldName(cls));
    }

    private static void assignEncodedOctets(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        out.line("this.%s = %s.encodeOctets(%s);", x.fieldName(cls), Util.class, x.fieldName(cls));
    }

    private static void assignOptionalField(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        out.line("this.%s = %s.orElse(null);", x.fieldName(cls), x.fieldName(cls));
    }

    private static boolean isDiscriminator(Set<Generator.Cls> interfaces, Generator.Field x) {
        return SchemasCodeWriter.discriminator(interfaces, x).isPresent();
    }

    private static Optional<Generator.Discriminator> discriminator(Set<Generator.Cls> interfaces, Generator.Field x) {
        return interfaces.stream().filter(y -> x.name.equals(y.discriminator.propertyName)).map(y -> y.discriminator).findFirst();
    }

    private static void validateMore(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        String raw = x.fieldName(cls);
        if (x.minLength.isPresent() && !x.isDateOrTime()) {
            out.line("%s.checkMinLength(%s, %s, \"%s\");", Preconditions.class, raw, x.minLength.get(), x.fieldName(cls));
        }
        if (x.maxLength.isPresent() && !x.isDateOrTime()) {
            out.line("%s.checkMaxLength(%s, %s, \"%s\");", Preconditions.class, raw, x.maxLength.get(), x.fieldName(cls));
        }
        if (x.pattern.isPresent() && !x.isDateOrTime()) {
            out.line("%s.checkMatchesPattern(%s, \"%s\", \"%s\");", Preconditions.class, raw, WriterUtil.escapePattern(x.pattern.get()), x.fieldName(cls));
        }
        if (x.min.isPresent()) {
            out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", Preconditions.class, raw, x.min.get().toString(), x.fieldName(cls), x.exclusiveMin);
        }
        if (x.max.isPresent()) {
            out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", Preconditions.class, raw, x.max.get().toString(), x.fieldName(cls), x.exclusiveMax);
        }
        if (x.isArray && x.minItems.isPresent()) {
            out.line("%s.checkMinSize(%s, %s, \"%s\");", Preconditions.class, x.fieldName(cls), x.minItems.get(), x.fieldName(cls));
        }
        if (x.isArray && x.maxItems.isPresent()) {
            out.line("%s.checkMaxSize(%s, %s, \"%s\");", Preconditions.class, x.fieldName(cls), x.maxItems.get(), x.fieldName(cls));
        }
    }

    private static void writeEqualsMethod(CodePrintWriter out, Generator.Cls cls) {
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public boolean equals(%s o) {", Object.class);
        out.line("if (this == o) {", new Object[0]);
        out.line("return true;", new Object[0]);
        out.closeParen();
        out.line("if (o == null || getClass() != o.getClass()) {", new Object[0]);
        out.line("return false;", new Object[0]);
        out.closeParen();
        out.right();
        String s = cls.fields.stream().map(x -> String.format("\n%s%s.equals(this.%s, other.%s)", out.indent(), out.add(Objects.class), x.fieldName(cls), x.fieldName(cls))).collect(Collectors.joining(" && "));
        out.left();
        if (!s.isEmpty()) {
            out.line("%s other = (%s) o;", cls.simpleName(), cls.simpleName());
        }
        out.line("return %s;", s.isEmpty() ? "true" : s);
        out.closeParen();
    }

    private static void writeHashCodeMethod(CodePrintWriter out, Generator.Cls cls) {
        String s;
        if (cls.fields.size() <= 3) {
            s = cls.fields.stream().map(x -> x.fieldName(cls)).collect(Collectors.joining(", "));
        } else {
            out.right().right().right();
            s = cls.fields.stream().map(x -> String.format("\n%s%s", out.indent(), x.fieldName(cls))).collect(Collectors.joining(", "));
            out.left().left().left();
        }
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public int hashCode() {", new Object[0]);
        out.line("return %s.hash(%s);", Objects.class, s);
        out.closeParen();
    }

    private static void writeToStringMethod(CodePrintWriter out, Generator.Cls cls) {
        String s;
        if (cls.fields.size() > 3) {
            out.right().right().right();
            s = cls.fields.stream().map(x -> String.format(",\n%s\"%s\", %s", out.indent(), x.fieldName(cls), x.fieldName(cls))).collect(Collectors.joining());
            out.left().left().left();
        } else {
            s = cls.fields.stream().map(x -> String.format(", \"%s\", %s", x.fieldName(cls), x.fieldName(cls))).collect(Collectors.joining(""));
        }
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public String toString() {", new Object[0]);
        out.line("return %s.toString(%s.class%s);", Util.class, cls.simpleName(), s);
        out.closeParen();
    }

    private static void ifValidate(Generator.Cls cls, CodePrintWriter out, Names names, Consumer<CodePrintWriter> consumer) {
        CodePrintWriter b = CodePrintWriter.create(out);
        out.right();
        consumer.accept(b);
        out.left();
        b.close();
        String text = b.text();
        if (text.isEmpty()) {
            return;
        }
        out.line("if (%s.config().validateInConstructor().test(%s.class)) {", out.add(names.globalsFullClassName()), cls.simpleName());
        out.left();
        out.print(text);
        out.line("}", new Object[0]);
    }

    private static void assignField(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
    }

    private static void writeGetters(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        Set interfaces = (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
        cls.fields.forEach(f -> {
            Optional<Generator.Discriminator> disc = SchemasCodeWriter.discriminator(interfaces, f);
            if (disc.isPresent()) {
                String value = String.format("%s.value(%s)", out.add(DiscriminatorHelper.class), f.fieldName(cls));
                SchemasCodeWriter.addOverrideAnnotation(out);
                SchemasCodeWriter.writeGetter(out, out.add(String.class), f.fieldName(cls), value);
            } else if (f.mapType.isPresent()) {
                if (!f.isArray && f.isAdditionalProperties()) {
                    SchemasCodeWriter.writeJsonAnySetter(out, cls, f);
                }
                out.println();
                String expression = f.isMapType(Generator.MapType.FIELD) ? (f.nullable ? (f.required ? (f.isArray ? f.fieldName(cls) : String.format("%s.ofNullable(%s.get())", out.add(Optional.class), f.fieldName(cls))) : f.fieldName(cls)) : (f.required ? f.fieldName(cls) : String.format("%s.ofNullable(%s)", out.add(Optional.class), f.fieldName(cls)))) : (f.nullable && !f.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES) ? (!f.isArray && f.required ? String.format("%s.ofNullable(%s.get())", out.add(Optional.class), f.fieldName(cls)) : f.fieldName(cls)) : f.fieldName(cls));
                SchemasCodeWriter.writeGetter(out, f.resolvedTypeMapPublic(out.imports()), f.fieldName(cls), expression);
            } else {
                out.println();
                String value = f.nullable ? (f.isArray ? f.fieldName(cls) : (f.required ? String.format("%s.ofNullable(%s.get())", out.add(Optional.class), f.fieldName(cls)) : f.fieldName(cls))) : (!f.isOctets() && !f.required ? String.format("%s.ofNullable(%s)", out.add(Optional.class), f.fieldName(cls)) : (f.isOctets() ? (f.required ? String.format("%s.decodeOctets(%s)", out.add(Util.class), f.fieldName(cls)) : String.format("%s.ofNullable(%s.decodeOctets(%s))", out.add(Optional.class), out.add(Util.class), f.fieldName(cls))) : f.fieldName(cls)));
                SchemasCodeWriter.writeGetter(out, f.resolvedTypePublicConstructor(out.imports()), f.fieldName(cls), value);
            }
        });
    }

    private static void writePropertiesMapGetter(CodePrintWriter out, Generator.Cls cls) {
        if (cls.fields.isEmpty()) {
            return;
        }
        Indent indent = out.indent().copy().right().right().right();
        String puts = cls.fields.stream().map(f -> String.format("\n%s.put(\"%s\", (%s) %s)", indent, f.name, out.add(Object.class), cls.fieldName((Generator.Field)f))).collect(Collectors.joining());
        out.println();
        out.line("%s<%s, %s> _internal_properties() {", Map.class, String.class, Object.class);
        out.line("return %s%s\n%s.build();", Maps.class, puts, indent);
        out.closeParen();
    }

    private static void writeMutators(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        List<Generator.Field> fields = cls.fields.stream().filter(x -> !SchemasCodeWriter.isDiscriminator(SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces), x)).collect(Collectors.toList());
        if (fields.size() <= 1) {
            return;
        }
        fields.forEach(x -> {
            Optional<String> tNonOptional;
            String t = x.mapType.isPresent() ? x.resolvedTypeMapPublic(out.imports()) : x.resolvedTypePublicConstructor(out.imports());
            out.println();
            out.line("public %s with%s(%s %s) {", cls.simpleName(), Names.upperFirst(x.fieldName(cls)), t, x.fieldName(cls));
            String params = fields.stream().filter(y -> !SchemasCodeWriter.isDiscriminator(SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces), y)).map(y -> {
                if (y.fieldName(cls).equals(x.fieldName(cls))) {
                    if (y.nullable && !y.required) {
                        return String.format("%s.of(%s.orElse(null))", out.add(JsonNullable.class), y.fieldName(cls));
                    }
                    return y.fieldName(cls);
                }
                return SchemasCodeWriter.nonMutatedFieldAsParameter(out, cls, y);
            }).collect(Collectors.joining(", "));
            out.line("return new %s(%s);", cls.simpleName(), params);
            out.closeParen();
            if (!x.mapType.isPresent() && (tNonOptional = x.resolvedTypePublicConstructorNonOptional(out.imports())).isPresent() && !tNonOptional.get().equals(t)) {
                out.println();
                out.line("public %s with%s(%s %s) {", cls.simpleName(), Names.upperFirst(x.fieldName(cls)), tNonOptional.get(), x.fieldName(cls));
                String params2 = fields.stream().filter(y -> !SchemasCodeWriter.isDiscriminator(SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces), y)).map(y -> {
                    if (y.fieldName(cls).equals(x.fieldName(cls))) {
                        if (y.nullable && !y.required) {
                            return String.format("%s.of(%s)", out.add(JsonNullable.class), y.fieldName(cls));
                        }
                        return String.format("%s.of(%s)", out.add(Optional.class), y.fieldName(cls));
                    }
                    return SchemasCodeWriter.nonMutatedFieldAsParameter(out, cls, y);
                }).collect(Collectors.joining(", "));
                out.line("return new %s(%s);", cls.simpleName(), params2);
                out.closeParen();
            }
        });
    }

    private static String nonMutatedFieldAsParameter(CodePrintWriter out, Generator.Cls cls, Generator.Field y) {
        if (y.nullable) {
            if (y.required) {
                return String.format("%s.ofNullable(%s.get())", out.add(Optional.class), y.fieldName(cls));
            }
            return y.fieldName(cls);
        }
        if (y.required) {
            return y.fieldName(cls);
        }
        if (y.isOctets()) {
            return String.format("%s.ofNullable(%s.decodeOctets(%s))", out.add(Optional.class), out.add(Util.class), y.fieldName(cls));
        }
        return String.format("%s.ofNullable(%s)", out.add(Optional.class), y.fieldName(cls));
    }

    private static void writeJsonAnySetter(CodePrintWriter out, Generator.Cls cls, Generator.Field f) {
        out.println();
        out.line("@%s", JsonAnySetter.class);
        if (f.nullable) {
            out.line("private void put(%s key, %s<%s> value) {", String.class, JsonNullable.class, out.add(f.fullClassName));
        } else {
            out.line("private void put(%s key, %s value) {", String.class, out.add(f.fullClassName));
        }
        out.line("this.%s.put(key, value);", f.fieldName(cls));
        out.closeParen();
    }

    private static void writeGetter(CodePrintWriter out, String returnImportedType, String fieldName, String value) {
        out.line("public %s %s() {", returnImportedType, fieldName);
        out.line("return %s;", value);
        out.closeParen();
    }

    private static void writeMemberClasses(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        cls.classes.forEach(c -> SchemasCodeWriter.writeClass(out, c, fullClassNameInterfaces, names));
    }
}

