/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Indent;

public final class CodePrintWriter
extends PrintWriter {
    private ByteArrayOutputStream bytes;
    private final Indent indent;
    private final Imports imports;

    public CodePrintWriter(OutputStream out, String fullClassName) {
        this(out, new Imports(fullClassName), new Indent());
    }

    private CodePrintWriter(OutputStream out, Imports imports, Indent indent) {
        super(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.indent = indent;
        this.imports = imports;
    }

    public static CodePrintWriter create(String fullClassName) {
        return CodePrintWriter.create(new Imports(fullClassName), new Indent());
    }

    public static CodePrintWriter create(CodePrintWriter w) {
        return CodePrintWriter.create(w.imports(), w.indent());
    }

    private static CodePrintWriter create(Imports imp, Indent indent) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        CodePrintWriter p = new CodePrintWriter((OutputStream)bytes, imp, indent);
        p.setBytes(bytes);
        return p;
    }

    private void setBytes(ByteArrayOutputStream bytes) {
        this.bytes = bytes;
    }

    public Indent indent() {
        return this.indent;
    }

    @Override
    public void println() {
        this.format("\n", new Object[0]);
    }

    public void line(String format, Object ... args) {
        Object[] args2 = new Object[args.length + 2];
        args2[0] = this.indent;
        for (int i = 0; i < args.length; ++i) {
            Object v = args[i];
            if (v instanceof Class) {
                v = this.imports.add((Class)v);
            }
            args2[i + 1] = v;
        }
        this.format("%s" + format + "\n", args2);
        if (format.endsWith("{")) {
            this.right();
        }
    }

    public CodePrintWriter left() {
        this.indent.left();
        return this;
    }

    public CodePrintWriter right() {
        this.indent.right();
        return this;
    }

    public String text() {
        this.flush();
        try {
            return this.bytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeParen() {
        this.indent.left();
        this.format("%s}\n", this.indent);
    }

    public Imports imports() {
        return this.imports;
    }

    public String add(String fullClassName) {
        return this.imports.add(fullClassName);
    }

    public String add(Class<?> cls) {
        return this.imports.add(cls);
    }

    public String fullClassName() {
        return this.imports.fullClassName();
    }

    public String pkg() {
        return Names.pkg(this.fullClassName());
    }

    public String simpleClassName() {
        return Names.simpleClassName(this.fullClassName());
    }
}

