/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import com.github.davidmoten.guavamini.Maps;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Apis;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.SchemaWithName;
import org.davidmoten.oa3.codegen.generator.ServerGeneratorType;
import org.davidmoten.oa3.codegen.util.ImmutableList;

public final class Names {
    private static final Set<String> javaReservedWords = Sets.newHashSet((Object[])new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "var", "hashCode", "toString"});
    private static final boolean LOG_SCHEMA_PATHS = false;
    private final Definition definition;
    private final OpenAPI api;
    private final ServerGeneratorType generatorType;

    Names(Definition definition) {
        this.definition = definition;
        this.generatorType = definition.generator().map(x -> ServerGeneratorType.valueOf(x.toUpperCase(Locale.ENGLISH))).orElse(ServerGeneratorType.SPRING2);
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        System.setProperty("maxYamlCodePoints", "999999999");
        OpenAPIParser parser = new OpenAPIParser();
        SwaggerParseResult result = parser.readLocation(definition.definition(), null, options);
        String errors = result.getMessages().stream().collect(Collectors.joining("\n"));
        if (!errors.isEmpty()) {
            if (definition.failOnParseErrors()) {
                throw new RuntimeException(errors);
            }
            System.out.println("[WARNING] Swagger Parse Errors:\n" + errors);
        }
        this.api = result.getOpenAPI();
        Names.superSchemas(this.api);
        Names.logSchemaFullClassNames(this.api);
    }

    private static void logSchemaFullClassNames(OpenAPI api) {
    }

    public OpenAPI api() {
        return this.api;
    }

    public String schemaNameToFullClassName(SchemaCategory category, String schemaName) {
        return this.definition.packages().basePackage() + "." + category.getPackageFragment() + "." + this.schemaNameToSimpleClassName(schemaName);
    }

    public String schemaNameToSimpleClassName(String schemaName) {
        return Names.simpleClassNameFromSimpleName(schemaName);
    }

    public File fullClassNameToJavaFile(String fullClassName) {
        return new File(this.definition.generatedSourceDirectory(), fullClassName.replace(".", File.separator) + ".java");
    }

    public String refToFullClassName(String ref) {
        String fullClassName;
        Preconditions.checkNotNull((Object)ref);
        if (!ref.startsWith("#")) {
            fullClassName = this.externalRefClassName(ref);
        } else {
            SchemaCategory category;
            if (ref.startsWith("#/components/schemas")) {
                category = SchemaCategory.SCHEMA;
            } else if (ref.startsWith("#/components/schemas")) {
                category = SchemaCategory.SCHEMA;
            } else if (ref.startsWith("#/components/responses")) {
                category = SchemaCategory.SCHEMA;
            } else if (ref.startsWith("#/components/parameters")) {
                category = SchemaCategory.SCHEMA;
            } else if (ref.startsWith("#/components/requestBodies")) {
                category = SchemaCategory.SCHEMA;
            } else if (ref.startsWith("#/components/pathItems")) {
                category = SchemaCategory.SCHEMA;
            } else {
                throw new RuntimeException("unexpected ref: " + ref);
            }
            String schemaName = ref.substring(ref.lastIndexOf("/") + 1);
            fullClassName = this.schemaNameToFullClassName(category, schemaName);
        }
        return fullClassName;
    }

    public static String simpleClassName(String fullClassName) {
        return Names.getLastItemInDotDelimitedString(fullClassName);
    }

    public static String pkg(String className) {
        return className.substring(0, className.lastIndexOf("."));
    }

    public static String toIdentifier(String s) {
        String candidate = Names.lowerFirst(Names.identifierCandidate(s));
        return Names.adjustIfReservedWord(candidate);
    }

    private static String adjustIfReservedWord(String candidate) {
        if (javaReservedWords.contains(candidate)) {
            return candidate + "_";
        }
        return candidate;
    }

    public static String toEnumIdentifier(String s) {
        String candidate = Names.identifierCandidate(s);
        if (javaReservedWords.contains(candidate.toUpperCase(Locale.ENGLISH))) {
            return candidate + "_";
        }
        return candidate;
    }

    private static String identifierCandidate(String s) {
        StringBuilder b = new StringBuilder();
        char lastCh = ' ';
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(ch)) {
                b.append("_");
            }
            if (Character.isJavaIdentifierPart(ch)) {
                b.append(ch);
            } else {
                ch = '_';
                if (lastCh != ch) {
                    b.append(ch);
                }
            }
            lastCh = ch;
        }
        String candidate = b.toString();
        return candidate;
    }

    public static String propertyNameToClassSimpleName(String propertyName) {
        return Names.upperFirst(Names.toIdentifier(propertyName));
    }

    public static String upperFirst(String name) {
        if (name.isEmpty()) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static String lowerFirst(String name) {
        return name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
    }

    private static String getLastItemInDotDelimitedString(String name) {
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public String clientClassName() {
        return this.definition.packages().basePackage() + "client.Client";
    }

    public File clientClassJavaFile() {
        return new File(this.definition.generatedSourceDirectory(), this.clientClassName().replace(".", File.separator) + ".java");
    }

    public static String propertyNameToFieldName(String propertyName) {
        return Names.lowerFirst(Names.toIdentifier(propertyName));
    }

    public static String schemaNameToFieldName(String schemaName) {
        return Names.lowerFirst(Names.toIdentifier(schemaName));
    }

    public static String toFieldName(String name) {
        return Names.lowerFirst(Names.toIdentifier(name));
    }

    public static String simpleClassNameFromSimpleName(String name) {
        return Names.upperFirst(Names.underscoreToCamel(Names.toIdentifier(Names.skipUnderscoresAtStart(name))));
    }

    @VisibleForTesting
    static String underscoreToCamel(String s) {
        char ch;
        StringBuilder b = new StringBuilder();
        b.append(s.charAt(0));
        for (int i = 1; i < s.length() - 1; ++i) {
            char ch2 = s.charAt(i);
            char next = s.charAt(i + 1);
            if (ch2 == '_') {
                if (next == '_') continue;
                b.append(Character.toUpperCase(next));
                ++i;
                continue;
            }
            b.append(ch2);
        }
        if (s.length() > 1 && (ch = s.charAt(s.length() - 1)) != '_') {
            b.append(ch);
        }
        return b.toString();
    }

    private static String skipUnderscoresAtStart(String s) {
        int i;
        for (i = 0; s.charAt(i) == '_' && i < s.length() - 1; ++i) {
        }
        return s.substring(i);
    }

    public static String enumNameToEnumConstant(String s) {
        if (s.isEmpty()) {
            return "BLANK";
        }
        return Names.camelToUpper(Names.toEnumIdentifier(s));
    }

    public static String camelToUpper(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && i < s.length() - 1 && Character.isUpperCase(s.charAt(i)) && Character.isLowerCase(s.charAt(i + 1)) && s.charAt(i - 1) != '_') {
                b.append("_");
            }
            b.append(Character.toUpperCase(s.charAt(i)));
        }
        return b.toString();
    }

    private static Map<Schema<?>, Set<Schema<?>>> superSchemas(OpenAPI api) {
        Predicate<Schema> predicate = x -> x instanceof ComposedSchema && ((ComposedSchema)x).getOneOf() != null;
        HashMap map = new HashMap();
        Names.schemas(api).entrySet().stream().flatMap(x -> Names.findSchemas(SchemaCategory.SCHEMA, (String)x.getKey(), (Schema)x.getValue(), predicate).stream()).map(x -> (ComposedSchema)x).forEach(x -> {
            for (Schema sch : x.getOneOf()) {
                HashSet<ComposedSchema> set = (HashSet<ComposedSchema>)map.get(sch);
                if (set == null) {
                    set = new HashSet<ComposedSchema>();
                    map.put(sch, set);
                }
                set.add((ComposedSchema)x);
            }
        });
        return map;
    }

    private static Map<String, Schema<?>> schemas(OpenAPI api) {
        if (api.getComponents() == null || api.getComponents().getSchemas() == null) {
            return Collections.emptyMap();
        }
        return api.getComponents().getSchemas();
    }

    private static List<Schema<?>> findSchemas(SchemaCategory category, String name, Schema<?> schema, Predicate<Schema<?>> predicate) {
        ArrayList list = new ArrayList();
        Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)ImmutableList.of((Object[])new SchemaWithName[]{new SchemaWithName(name, schema)}), Maps.empty(), (c, schemaPath) -> {
            if (predicate.test(((SchemaWithName)schemaPath.last()).schema)) {
                list.add(((SchemaWithName)schemaPath.last()).schema);
            }
        });
        return list;
    }

    public String externalRefClassName(String ref) {
        return this.definition.externalRefClassName(ref);
    }

    public String globalsFullClassName() {
        return this.definition.packages().basePackage() + ".Globals";
    }

    static Map<String, String> getEnumValueToIdentifierMap(List<?> values) {
        HashMap<String, String> map = new HashMap<String, String>();
        LinkedHashSet set = new LinkedHashSet();
        values.forEach(o -> set.add(String.valueOf(o)));
        block0: for (String o2 : set) {
            int i = 0;
            String name = Names.enumNameToEnumConstant(o2);
            while (true) {
                String candidate;
                if (!map.containsValue(candidate = name + (i == 0 ? "" : "_" + i))) {
                    map.put(o2, candidate);
                    continue block0;
                }
                ++i;
            }
        }
        return map;
    }

    public boolean mapIntegerToBigInteger() {
        return this.definition.mapIntegerToBigInteger();
    }

    public static String toIdentifier(ImmutableList<String> list) {
        StringBuilder b = new StringBuilder();
        for (String s : list) {
            b.append(Names.upperFirst(Names.camelifyOnSeparatorCharacters(s)));
        }
        return Names.toIdentifier(b.toString());
    }

    private static String camelifyOnSeparatorCharacters(String s) {
        StringBuilder b = new StringBuilder();
        boolean start = true;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '/' || ch == '{' || ch == '}' || ch == '-' || ch == '_' || ch == '.') {
                start = true;
                continue;
            }
            if (start) {
                b.append(Character.toUpperCase(ch));
            } else {
                b.append(ch);
            }
            start = false;
        }
        return b.toString();
    }

    public String serviceControllerFullClassName() {
        return this.definition.packages().basePackage() + ".service.ServiceController";
    }

    public String serviceInterfaceFullClassName() {
        return this.definition.packages().basePackage() + ".service.Service";
    }

    public String applicationFullClassName() {
        return this.definition.packages().basePackage() + ".Application";
    }

    public String clientFullClassName() {
        return this.definition.packages().basePackage() + ".client.Client";
    }

    public String jacksonConfigurationFullClassName() {
        return this.definition.packages().basePackage() + ".service.JacksonConfiguration";
    }

    public Parameter lookupParameter(String name) {
        return Names.parameters(this.api).get(Names.lastComponent(name));
    }

    private static Map<String, Parameter> parameters(OpenAPI api) {
        if (api.getComponents() == null || api.getComponents().getParameters() == null) {
            return Collections.emptyMap();
        }
        return api.getComponents().getParameters();
    }

    public static String lastComponent(String ref) {
        int i = ref.lastIndexOf(47);
        return ref.substring(i + 1);
    }

    public RequestBody lookupRequestBody(String ref) {
        return Names.requestBodies(this.api).get(Names.lastComponent(ref));
    }

    private static Map<String, RequestBody> requestBodies(OpenAPI api) {
        if (api.getComponents() == null || api.getComponents().getRequestBodies() == null) {
            return Collections.emptyMap();
        }
        return api.getComponents().getRequestBodies();
    }

    public ApiResponse lookupResponse(String ref) {
        return this.responses(this.api).get(Names.lastComponent(ref));
    }

    private Map<String, ApiResponse> responses(OpenAPI api) {
        if (api.getComponents() == null || api.getComponents().getResponses() == null) {
            return Collections.emptyMap();
        }
        return api.getComponents().getResponses();
    }

    public ServerGeneratorType generatorType() {
        return this.generatorType;
    }

    public boolean mapNumberToBigDecimal() {
        return this.definition.mapNumberToBigDecimal();
    }

    private static /* synthetic */ void lambda$logSchemaFullClassNames$1(SchemaCategory category, ImmutableList schemaPath) {
        if (!Apis.isComplexSchema(((SchemaWithName)schemaPath.last()).schema)) {
            System.out.println(schemaPath);
        }
    }
}

