/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.davidmoten.oa3.codegen.generator.Apis;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.Visitor;
import org.davidmoten.oa3.codegen.generator.internal.Mutable;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.writer.ClientCodeWriter;
import org.davidmoten.oa3.codegen.generator.writer.ServerCodeWriterSpringBoot;
import org.davidmoten.oa3.codegen.util.ImmutableList;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientServerGenerator {
    private final Names names;
    private final Map<String, Generator.Cls> refCls;
    private final Map<Schema<?>, Generator.Cls> schemaCls;

    public ClientServerGenerator(Definition definition) {
        this.names = new Names(definition);
        HashMap<String, Generator.Cls> refCls = new HashMap<String, Generator.Cls>();
        HashMap schemaCls = new HashMap();
        Generator.MyVisitor v = new Generator.MyVisitor(this.names);
        Apis.visitSchemas((OpenAPI)this.names.api(), (Visitor)v);
        for (Generator.MyVisitor.Result result : v.results()) {
            Generator.Cls c = result.cls;
            if (!c.topLevel) continue;
            String refPrefix = c.category.refPrefix();
            String ref = refPrefix + (String)c.name.get();
            refCls.put(ref, c);
            schemaCls.put(c.schema.get(), c);
        }
        this.refCls = refCls;
        this.schemaCls = schemaCls;
    }

    public void generateServer() {
        List methods = this.collectMethods();
        ServerCodeWriterSpringBoot.writeServiceClasses((Names)this.names, (List)methods);
    }

    public void generateClient() {
        List methods = this.collectMethods();
        ClientCodeWriter.writeClientClass((Names)this.names, (List)methods);
    }

    private List<Method> collectMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (this.names.api().getPaths() != null) {
            this.names.api().getPaths().forEach((pathName, pathItem) -> this.gatherMethods(pathName, pathItem, methods));
        }
        return methods;
    }

    private void gatherMethods(String pathName, PathItem pathItem, List<Method> methods) {
        pathItem = Apis.resolveRefs((OpenAPI)this.names.api(), (PathItem)pathItem);
        pathItem.readOperationsMap().forEach((method, operation) -> this.gatherMethods(pathName, method, operation, methods));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherMethods(String pathName, PathItem.HttpMethod method, Operation operation, List<Method> methods) {
        void var8_18;
        void var6_8;
        Content content;
        String methodName = operation.getOperationId() != null ? Names.toIdentifier((String)operation.getOperationId()) : Names.toIdentifier((ImmutableList)ImmutableList.of((Object[])new String[]{pathName, method.toString().toLowerCase(Locale.ENGLISH)}));
        Optional optional = Optional.empty();
        ArrayList<Param> params = new ArrayList<Param>();
        Optional optional2 = Optional.empty();
        ArrayList consumes = new ArrayList();
        ArrayList produces = new ArrayList();
        HashSet parameterNames = new HashSet();
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(p -> {
                Param param;
                p = this.resolveParameterRefs(p);
                boolean isArray = false;
                Schema s = p.getSchema();
                if (s == null) {
                    System.out.println("[WARN] parameter not without schema not supported yet, skipping:\n" + p);
                    return;
                }
                Schema resolvedOriginal = this.resolveRefs(s);
                if (Util.isArray((Schema)s)) {
                    isArray = true;
                    s = s.getItems();
                }
                s = this.resolveRefs(s);
                Optional<Object> defaultValue = Optional.ofNullable(s.getDefault());
                String parameterName = Names.toIdentifier((String)p.getName());
                int i = 2;
                while (parameterNames.contains(parameterName)) {
                    parameterName = Names.toIdentifier((String)p.getName()) + i;
                    ++i;
                }
                parameterNames.add(parameterName);
                if (Util.isPrimitive((Schema)s)) {
                    Class c = Util.toClass((String)Util.getTypeOrThrow((Schema)s), (String)s.getFormat(), (Map)s.getExtensions(), (boolean)this.names.mapIntegerToBigInteger(), (boolean)this.names.mapNumberToBigDecimal());
                    param = new Param(p.getName(), parameterName, defaultValue, p.getRequired().booleanValue(), c.getCanonicalName(), isArray, false, ClientServerGenerator.constraints((Schema)s), ClientServerGenerator.toParamType((Parameter)p), false, Optional.ofNullable(p.getDescription()), Optional.empty(), Optional.empty());
                } else {
                    Generator.Cls cls = (Generator.Cls)this.schemaCls.get(resolvedOriginal);
                    param = new Param(p.getName(), parameterName, defaultValue, p.getRequired().booleanValue(), cls.fullClassName, isArray, false, ClientServerGenerator.constraints((Schema)s), ClientServerGenerator.toParamType((Parameter)p), true, Optional.ofNullable(p.getDescription()), Optional.empty(), Optional.empty());
                }
                params.add(param);
            });
        }
        if (operation.getRequestBody() != null) {
            RequestBody b = this.resolveRefs(operation.getRequestBody());
            MediaType mediaType = this.mediaType(b.getContent(), "application/json").map(Map.Entry::getValue).orElse(null);
            if (mediaType == null) {
                mediaType = this.mediaType(b.getContent(), "application/xml").map(Map.Entry::getValue).orElse(null);
            }
            boolean isMultipartFormData = mediaType == null ? (mediaType = (MediaType)this.mediaType(b.getContent(), "multipart/form-data").map(Map.Entry::getValue).orElse(null)) != null : false;
            boolean isFormUrlEncoded = mediaType == null ? (mediaType = (MediaType)this.mediaType(b.getContent(), "application/x-www-form-urlencoded").map(Map.Entry::getValue).orElse(null)) != null : false;
            if (mediaType != null) {
                Schema schema = mediaType.getSchema();
                if (schema != null) {
                    if (this.schemaCls.get(schema) == null) throw new RuntimeException("unexpected");
                    String fullClassName = this.resolveRefsFullClassName(schema);
                    ParamType paramType = isMultipartFormData ? ParamType.MULTIPART_FORM_DATA : (isFormUrlEncoded ? ParamType.FORM_URLENCODED : ParamType.BODY);
                    params.add(new Param("requestBody", "requestBody", Optional.ofNullable(schema.getDefault()), ((Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)b.getRequired(), (Object)true)).booleanValue(), fullClassName, false, true, ClientServerGenerator.constraints((Schema)schema), paramType, false, Optional.ofNullable(schema.getDescription()), Optional.empty(), Optional.empty()));
                } else {
                    this.addRequestBodyOctetStreamParameter(params, b, Optional.empty());
                }
            } else {
                System.out.println("TODO handle request body with media types " + b.getContent().keySet());
            }
            consumes = new ArrayList(b.getContent().keySet());
        }
        Optional response = ClientServerGenerator.primaryResponse((ApiResponses)operation.getResponses());
        Optional<String> primaryStatusCode = response.map(x -> x.statusCode);
        Mutable primaryMimeType = Mutable.create(null);
        if (response.isPresent() && ((StatusCodeApiResponse)response.get()).response != null && (content = this.resolveResponseRefs(((StatusCodeApiResponse)response.get()).response).getContent()) != null) {
            primaryMimeType.value = "application/json";
            MediaType mediaType = this.mediaType(content, "application/json").map(Map.Entry::getValue).orElse(null);
            if (mediaType == null) {
                primaryMimeType.value = "application/xml";
                mediaType = this.mediaType(content, (String)primaryMimeType.value).map(Map.Entry::getValue).orElse(null);
            }
            if (mediaType != null) {
                if (mediaType.getSchema() == null) {
                    Optional<String> optional3 = Optional.of(Object.class.getCanonicalName());
                } else {
                    Optional<String> optional4 = Optional.of(this.resolveRefsFullClassName(mediaType.getSchema()));
                }
            } else {
                void var8_16;
                String defaultReturnClassFullName = byte[].class.getCanonicalName();
                Optional<String> optional5 = content.keySet().stream().filter(x -> !"default".equals(x)).map(x -> {
                    primaryMimeType.value = x;
                    if (x.startsWith("text/")) {
                        return String.class.getCanonicalName();
                    }
                    return defaultReturnClassFullName;
                }).findFirst();
                if (!optional5.isPresent()) {
                    primaryMimeType.value = "default";
                    MediaType a = (MediaType)content.get(primaryMimeType.value);
                    if (a == null) {
                        Optional optional6 = Optional.empty();
                    } else {
                        Optional<String> optional7 = Optional.of(this.resolveRefsFullClassName(a.getSchema()));
                    }
                }
                if (!var8_16.isPresent()) {
                    primaryMimeType.value = null;
                }
            }
            Optional<String> optional8 = Optional.of(((StatusCodeApiResponse)response.get()).statusCode);
            produces = new ArrayList(content.keySet());
        }
        List responseDescriptors = this.responseDescriptors(operation);
        boolean includeForServerGeneration = operation.getExtensions() != null ? Boolean.TRUE.equals(operation.getExtensions().getOrDefault("x-openapi-codegen-include-for-server-generation", "")) : true;
        Method m = new Method(methodName, (Optional)var6_8, params, (Optional)var8_18, pathName, method, consumes, produces, Optional.ofNullable(operation.getDescription()), primaryStatusCode, Optional.ofNullable(primaryMimeType.value), responseDescriptors, includeForServerGeneration);
        methods.add(m);
    }

    private static ParamType toParamType(Parameter p) {
        if (p instanceof QueryParameter) {
            return ParamType.QUERY;
        }
        if (p instanceof PathParameter) {
            return ParamType.PATH;
        }
        if (p instanceof HeaderParameter) {
            return ParamType.HEADER;
        }
        if (p instanceof CookieParameter) {
            return ParamType.COOKIE;
        }
        return ParamType.valueOf((String)p.getIn().toUpperCase(Locale.ENGLISH));
    }

    private void addRequestBodyOctetStreamParameter(List<Param> params, RequestBody b, Optional<String> contentType) {
        String fullClassName = byte[].class.getCanonicalName();
        params.add(new Param("requestBody", "requestBody", Optional.empty(), ((Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)b.getRequired(), (Object)true)).booleanValue(), fullClassName, false, true, Constraints.empty(), ParamType.BODY, false, Optional.empty(), contentType, Optional.empty()));
    }

    private Optional<Map.Entry<String, MediaType>> mediaType(Content content, String mimeType) {
        return content.entrySet().stream().filter(x -> ((String)x.getKey()).replaceAll(";.*", "").equalsIgnoreCase(mimeType)).findFirst();
    }

    private List<ResponseDescriptor> responseDescriptors(Operation operation) {
        ArrayList<ResponseDescriptor> list = new ArrayList<ResponseDescriptor>();
        operation.getResponses().forEach((statusCode, response) -> {
            if ((response = this.resolveResponseRefs(response)).getContent() != null) {
                response.getContent().forEach((contentType, mediaType) -> {
                    String fullClassName = mediaType.getSchema() == null ? byte[].class.getCanonicalName() : this.resolveRefsFullClassName(mediaType.getSchema());
                    list.add(new ResponseDescriptor(statusCode, contentType, fullClassName));
                });
            }
        });
        return list;
    }

    private RequestBody resolveRefs(RequestBody b) {
        while (b.get$ref() != null) {
            b = this.names.lookupRequestBody(b.get$ref());
        }
        return b;
    }

    private static Constraints constraints(Schema<?> schema) {
        return new Constraints(Optional.ofNullable(schema.getMinLength()), Optional.ofNullable(schema.getMaxLength()), Optional.ofNullable(schema.getMinimum()), Optional.ofNullable(schema.getMaximum()), Optional.ofNullable(schema.getExclusiveMinimumValue()), Optional.ofNullable(schema.getExclusiveMaximumValue()), Optional.ofNullable(schema.getMinItems()), Optional.ofNullable(schema.getMaxItems()), Optional.ofNullable(schema.getPattern()));
    }

    private static Optional<StatusCodeApiResponse> primaryResponse(ApiResponses responses) {
        if (responses.get((Object)"200") != null) {
            return Optional.of(new StatusCodeApiResponse("200", (ApiResponse)responses.get((Object)"200")));
        }
        for (Map.Entry r : responses.entrySet()) {
            if (!ClientServerGenerator.is2XX((String)((String)r.getKey()))) continue;
            return Optional.of(new StatusCodeApiResponse((String)r.getKey(), (ApiResponse)r.getValue()));
        }
        return Optional.empty();
    }

    private static boolean is2XX(String key) {
        return key.length() == 3 && key.startsWith("2");
    }

    private Parameter resolveParameterRefs(Parameter p) {
        while (p.get$ref() != null) {
            p = this.names.lookupParameter(p.get$ref());
        }
        return p;
    }

    private ApiResponse resolveResponseRefs(ApiResponse r) {
        while (r.get$ref() != null) {
            String ref = r.get$ref();
            if ((r = this.names.lookupResponse(ref)) != null) continue;
            throw new RuntimeException("could not find response " + ref);
        }
        return r;
    }

    private String resolveRefsFullClassName(Schema<?> schema) {
        return ((Generator.Cls)this.schemaCls.get((Object)this.resolveRefs(schema))).fullClassName;
    }

    private Schema<?> resolveRefs(Schema<?> schema) {
        Schema s = schema;
        while (s.get$ref() != null) {
            String ref = s.get$ref();
            Generator.Cls c = (Generator.Cls)this.refCls.get(ref);
            if (c == null) {
                throw new IllegalArgumentException("Cls not found for schema=\n" + schema + "\nrefCls map keys=\n" + this.refCls.keySet());
            }
            s = (Schema)c.schema.get();
            if (s != null) continue;
            throw new IllegalArgumentException("$ref not found: " + ref);
        }
        return s;
    }
}

