/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Maps;
import com.github.davidmoten.guavamini.Preconditions;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.SchemaWithName;
import org.davidmoten.oa3.codegen.generator.Visitor;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.util.ImmutableList;

/*
 * Exception performing whole class analysis ignored.
 */
class Apis {
    private static List<Class<? extends Schema<?>>> COMPLEX_SCHEMA_CLASSES = Lists.of((Object[])new Class[]{ObjectSchema.class, MapSchema.class, ComposedSchema.class, ArraySchema.class});

    Apis() {
    }

    static void visitSchemas(OpenAPI api, Visitor visitor) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((name, pathItem) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.PATH, (ImmutableList)ImmutableList.of((Object[])new String[]{name}), (PathItem)pathItem, (Visitor)visitor, (OpenAPI)api));
        }
        if (api.getComponents() != null) {
            if (api.getComponents().getParameters() != null) {
                api.getComponents().getParameters().forEach((name, parameter) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.PARAMETER, (ImmutableList)ImmutableList.of((Object[])new String[]{name}), (Parameter)parameter, (Visitor)visitor, (OpenAPI)api));
            }
            if (api.getComponents().getPathItems() != null) {
                api.getComponents().getPathItems().forEach((name, pathItem) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.PATH_ITEM, (ImmutableList)ImmutableList.of((Object[])new String[]{name}), (PathItem)pathItem, (Visitor)visitor, (OpenAPI)api));
            }
            if (api.getComponents().getRequestBodies() != null) {
                api.getComponents().getRequestBodies().forEach((name, requestBody) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.REQUEST_BODY, (ImmutableList)ImmutableList.of((Object[])new String[]{name}), (RequestBody)requestBody, (Visitor)visitor, (OpenAPI)api));
            }
            if (api.getComponents().getResponses() != null) {
                api.getComponents().getResponses().forEach((name, response) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.RESPONSE, (ImmutableList)ImmutableList.of((Object[])new String[]{name}), (ApiResponse)response, (Visitor)visitor, (OpenAPI)api));
            }
            if (api.getComponents().getHeaders() != null) {
                api.getComponents().getHeaders().forEach((key, header) -> Apis.visitSchemas((SchemaCategory)SchemaCategory.HEADER, (ImmutableList)ImmutableList.of((Object[])new String[]{key}), (Header)header, (Visitor)visitor, (OpenAPI)api));
            }
            if (api.getComponents().getSchemas() != null) {
                api.getComponents().getSchemas().forEach((key, value) -> Apis.visitSchemas((String)key, (Schema)value, (Visitor)visitor));
            }
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> names, Header header, Visitor visitor, OpenAPI api) {
        if (header != null) {
            header = Apis.resolveRefs((OpenAPI)api, (Header)header);
            Apis.visitSchemas((SchemaCategory)category, names, (Schema)header.getSchema(), (Map)Maps.empty(), (Visitor)visitor);
        }
    }

    private static Header resolveRefs(OpenAPI api, Header header) {
        while (header.get$ref() != null) {
            header = (Header)api.getComponents().getHeaders().get(Names.lastComponent((String)header.get$ref()));
        }
        return header;
    }

    private static void visitSchemas(String name, Schema<?> schema, Visitor visitor) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        Apis.visitSchemas((SchemaCategory)SchemaCategory.SCHEMA, (ImmutableList)ImmutableList.of((Object[])new SchemaWithName[]{new SchemaWithName(Apis.stripLeadingSlash((String)name), schema)}), (Map)Maps.empty(), (Visitor)visitor);
    }

    private static String stripLeadingSlash(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> names, PathItem pathItem, Visitor visitor, OpenAPI api) {
        if ((pathItem = Apis.resolveRefs((OpenAPI)api, (PathItem)pathItem)).readOperationsMap() != null) {
            pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
                ImmutableList names2 = operation.getOperationId() != null ? ImmutableList.of((Object[])new String[]{operation.getOperationId()}) : names.add((Object)Names.upperFirst((String)httpMethod.toString().toLowerCase(Locale.ENGLISH)));
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)names2, (Operation)operation, (Visitor)visitor, (OpenAPI)api);
            });
        }
        if (pathItem.getParameters() != null) {
            pathItem.getParameters().forEach(p -> {
                p = Apis.resolveRefs((OpenAPI)api, (Parameter)p);
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)names.add((Object)p.getName()), (Parameter)p, (Visitor)visitor, (OpenAPI)api);
            });
        }
    }

    static PathItem resolveRefs(OpenAPI api, PathItem item) {
        while (item.get$ref() != null) {
            item = (PathItem)api.getComponents().getPathItems().get(Names.lastComponent((String)item.get$ref()));
        }
        return item;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Operation operation, Visitor visitor, OpenAPI api) {
        if (operation == null) {
            return;
        }
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(p -> {
                p = Apis.resolveRefs((OpenAPI)api, (Parameter)p);
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add((Object)p.getName()), (Parameter)p, (Visitor)visitor, (OpenAPI)api);
            });
        }
        Apis.visitSchemas((SchemaCategory)category, list, (RequestBody)operation.getRequestBody(), (Visitor)visitor, (OpenAPI)api);
        if (operation.getResponses() != null) {
            operation.getResponses().forEach((statusCode, response) -> {
                response = Apis.resolveRefs((OpenAPI)api, (ApiResponse)response);
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add(statusCode), (ApiResponse)response, (Visitor)visitor, (OpenAPI)api);
            });
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, ApiResponse response, Visitor visitor, OpenAPI api) {
        response = Apis.resolveRefs((OpenAPI)api, (ApiResponse)response);
        Apis.visitSchemas((SchemaCategory)category, (ImmutableList)(category == SchemaCategory.RESPONSE ? list : list.add((Object)"Response")), (Content)response.getContent(), (Visitor)visitor);
    }

    private static ApiResponse resolveRefs(OpenAPI api, ApiResponse response) {
        while (response.get$ref() != null) {
            response = (ApiResponse)api.getComponents().getResponses().get(Names.lastComponent((String)response.get$ref()));
        }
        return response;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, RequestBody requestBody, Visitor visitor, OpenAPI api) {
        if (requestBody != null) {
            requestBody = Apis.resolveRefs((OpenAPI)api, (RequestBody)requestBody);
            Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add((Object)"Request"), (Content)requestBody.getContent(), (Visitor)visitor);
        }
    }

    private static RequestBody resolveRefs(OpenAPI api, RequestBody requestBody) {
        while (requestBody.get$ref() != null) {
            requestBody = (RequestBody)api.getComponents().getRequestBodies().get(Names.lastComponent((String)requestBody.get$ref()));
        }
        return requestBody;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Content content, Visitor visitor) {
        if (content != null) {
            content.forEach((mimeType, mediaType) -> {
                if (mimeType.equals("application/json")) {
                    Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list, (MediaType)mediaType, (Visitor)visitor);
                } else {
                    Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add(mimeType), (MediaType)mediaType, (Visitor)visitor);
                }
            });
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, MediaType mediaType, Visitor visitor) {
        Apis.visitSchemas((SchemaCategory)category, list, (Schema)mediaType.getSchema(), (Map)mediaType.getEncoding(), (Visitor)visitor);
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Parameter parameter, Visitor visitor, OpenAPI api) {
        if (parameter != null) {
            if ((parameter = Apis.resolveRefs((OpenAPI)api, (Parameter)parameter)).getSchema() != null && !Util.isPrimitive((Schema)parameter.getSchema())) {
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add((Object)"Parameter").add((Object)parameter.getName()), (Schema)parameter.getSchema(), (Map)Maps.empty(), (Visitor)visitor);
            }
            Apis.visitSchemas((SchemaCategory)category, (ImmutableList)list.add((Object)"Parameter").add((Object)parameter.getName()), (Content)parameter.getContent(), (Visitor)visitor);
        }
    }

    private static Parameter resolveRefs(OpenAPI api, Parameter parameter) {
        while (parameter.get$ref() != null) {
            parameter = (Parameter)api.getComponents().getParameters().get(Names.lastComponent((String)parameter.get$ref()));
        }
        return parameter;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Schema<?> schema, Map<String, Encoding> propertyEncoding, Visitor visitor) {
        if (schema != null) {
            ImmutableList schemaPath = ImmutableList.of((Object[])new SchemaWithName[]{new SchemaWithName(Names.toIdentifier(list), schema)});
            Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath, propertyEncoding, (Visitor)visitor);
        }
    }

    static void visitSchemas(SchemaCategory category, ImmutableList<SchemaWithName> schemaPath, Map<String, Encoding> propertyEncoding, Visitor visitor) {
        Schema schema = ((SchemaWithName)schemaPath.last()).schema;
        visitor.startSchema(category, schemaPath);
        if (schema instanceof ComposedSchema && ((ComposedSchema)schema).getAnyOf() != null && (schema.getProperties() != null || schema.getAdditionalProperties() != null || schema.getAdditionalItems() != null)) {
            schema.setProperties(null);
            schema.setAdditionalProperties(null);
            schema.setAdditionalItems(null);
            System.out.println("[WARN] anyOf with extra properties not supported yet, extra properties stripped");
        } else if (schema instanceof ObjectSchema && schema.getProperties() == null && schema.getAdditionalProperties() == null) {
            schema.setAdditionalProperties((Object)Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(schema.getAdditionalProperties())) {
            schema.setAdditionalProperties((Object)new Schema());
        }
        if (schema.getAdditionalProperties() instanceof Schema && schema.getEnum() == null) {
            Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName("properties", (Schema)schema.getAdditionalProperties())), (Map)Maps.empty(), (Visitor)visitor);
        } else if (schema.getNot() != null) {
            Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName("not", schema.getNot())), (Map)Maps.empty(), (Visitor)visitor);
        }
        if (schema.getProperties() != null && !(schema instanceof ArraySchema)) {
            schema.getProperties().entrySet().forEach(x -> {
                Schema sch;
                if (propertyEncoding != null && propertyEncoding.containsKey(x.getKey())) {
                    Encoding encoding = (Encoding)propertyEncoding.get(x.getKey());
                    if (encoding.getContentType() != null) {
                        List contentTypes = Arrays.stream(encoding.getContentType().split(",")).map(y -> y.trim()).collect(Collectors.toList());
                        Schema contentTypeSchema = Apis.enumSchema(contentTypes);
                        if (contentTypes.size() == 1) {
                            contentTypeSchema.setDefault(contentTypes.get(0));
                        }
                        contentTypeSchema.setExtensions(Maps.hashMap().put((Object)"x-openapi-codegen-internal-has-encoding", (Object)Boolean.TRUE).build());
                        ObjectSchema combined = new ObjectSchema();
                        combined.setProperties(new LinkedHashMap());
                        combined.getProperties().put("contentType", contentTypeSchema);
                        combined.getProperties().put("value", x.getValue());
                        combined.setRequired(Lists.of((Object[])new String[]{"value", "contentType"}));
                        combined.setExtensions(Maps.hashMap().put((Object)"x-openapi-codegen-internal-has-encoding", (Object)Boolean.TRUE).build());
                        sch = combined;
                    } else {
                        sch = (Schema)x.getValue();
                    }
                } else {
                    sch = (Schema)x.getValue();
                }
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName((String)x.getKey(), sch)), (Map)Maps.empty(), (Visitor)visitor);
            });
        }
        if (schema instanceof ArraySchema) {
            ArraySchema a = (ArraySchema)schema;
            if (a.getItems() != null) {
                Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName(((SchemaWithName)schemaPath.last()).name + "Item", a.getItems())), (Map)Maps.empty(), (Visitor)visitor);
            }
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema a = (ComposedSchema)schema;
            if (a.getAllOf() != null) {
                a.getAllOf().forEach(x -> Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName(null, x)), (Map)Maps.empty(), (Visitor)visitor));
            }
            if (a.getOneOf() != null) {
                a.getOneOf().forEach(x -> Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName(null, x)), (Map)Maps.empty(), (Visitor)visitor));
            }
            if (a.getAnyOf() != null) {
                a.getAnyOf().forEach(x -> Apis.visitSchemas((SchemaCategory)category, (ImmutableList)schemaPath.add((Object)new SchemaWithName(null, x)), (Map)Maps.empty(), (Visitor)visitor));
            }
        }
        visitor.finishSchema(category, schemaPath);
    }

    private static Schema<String> enumSchema(List<String> values) {
        Schema schema = new Schema();
        schema.setType("string");
        schema.setEnum(values);
        return schema;
    }

    static final boolean isComplexSchema(Schema<?> schema) {
        for (Class cls : COMPLEX_SCHEMA_CLASSES) {
            if (!cls.isAssignableFrom(schema.getClass())) continue;
            return true;
        }
        return schema.getProperties() != null;
    }
}

