/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.davidmoten.guavamini.Maps;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.ErrorHandler;
import org.davidmoten.oa3.codegen.spring.runtime.RequestPreconditions;
import org.davidmoten.oa3.codegen.spring.runtime.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServerCodeWriterSpringBoot {
    public static void writeServiceClasses(Names names, List<ClientServerGenerator.Method> methods) {
        ServerCodeWriterSpringBoot.writeApplicationClass((Names)names);
        ServerCodeWriterSpringBoot.writeJacksonConfigurationClass((Names)names);
        List includedMethods = methods.stream().filter(x -> x.includeForServerGeneration).collect(Collectors.toList());
        ServerCodeWriterSpringBoot.writeServiceControllerClass((Names)names, includedMethods);
        ServerCodeWriterSpringBoot.writeServiceInterfaceClass((Names)names, includedMethods);
    }

    private static void writeApplicationClass(Names names) {
        CodePrintWriter out = CodePrintWriter.create((String)names.applicationFullClassName(), (Predicate)names.simpleNameInPackage(names.applicationFullClassName()));
        ServerCodeWriterSpringBoot.writeApplicationClass((CodePrintWriter)out);
        WriterUtil.writeContent((Names)names, (CodePrintWriter)out);
    }

    private static void writeApplicationClass(CodePrintWriter out) {
        out.line("package %s;", new Object[]{out.pkg()});
        out.println();
        out.format("%s", new Object[]{"IMPORTS_HERE"});
        out.println();
        out.line("@%s", new Object[]{SpringBootApplication.class});
        WriterUtil.addGeneratedAnnotation((CodePrintWriter)out);
        out.line("public class %s {", new Object[]{out.simpleClassName()});
        out.println();
        out.line("public static void main(%s[] args) {", new Object[]{String.class});
        out.line("%s.run(%s.class, args);", new Object[]{SpringApplication.class, out.simpleClassName()});
        out.closeParen();
        out.left();
        out.println();
        out.line("}", new Object[0]);
    }

    private static void writeJacksonConfigurationClass(Names names) {
        String fullClassName = names.jacksonConfigurationFullClassName();
        CodePrintWriter out = CodePrintWriter.create((String)fullClassName, (Predicate)names.simpleNameInPackage(fullClassName));
        ServerCodeWriterSpringBoot.writeJacksonConfigurationClass((CodePrintWriter)out, (Names)names);
        WriterUtil.writeContent((Names)names, (CodePrintWriter)out);
    }

    private static void writeJacksonConfigurationClass(CodePrintWriter out, Names names) {
        out.line("package %s;", new Object[]{out.pkg()});
        out.println();
        out.format("%s", new Object[]{"IMPORTS_HERE"});
        out.println();
        out.line("@%s", new Object[]{Configuration.class});
        WriterUtil.addGeneratedAnnotation((CodePrintWriter)out);
        out.line("public class %s {", new Object[]{out.simpleClassName()});
        out.println();
        out.line("private final %s config;", new Object[]{Config.class});
        out.println();
        out.line("public %s(@%s(required = false) %s config) {", new Object[]{out.simpleClassName(), Autowired.class, Config.class});
        out.line("this.config = config == null ? %s.config() : config;", new Object[]{out.add(names.globalsFullClassName())});
        out.closeParen();
        out.println();
        out.line("@%s", new Object[]{Bean.class});
        out.line("@%s", new Object[]{Primary.class});
        out.line("public %s objectMapper() {", new Object[]{ObjectMapper.class});
        out.line("return config.mapper();", new Object[0]);
        out.closeParen();
        out.left();
        out.println();
        out.line("}", new Object[0]);
    }

    private static void writeServiceControllerClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.serviceControllerFullClassName();
        CodePrintWriter out = CodePrintWriter.create((String)fullClassName, (Predicate)names.simpleNameInPackage(fullClassName));
        ServerCodeWriterSpringBoot.writeServiceControllerClass((CodePrintWriter)out, (Names)names, methods);
        WriterUtil.writeContent((Names)names, (CodePrintWriter)out);
    }

    private static void writeServiceInterfaceClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.serviceInterfaceFullClassName();
        CodePrintWriter out = CodePrintWriter.create((String)fullClassName, (Predicate)names.simpleNameInPackage(fullClassName));
        ServerCodeWriterSpringBoot.writeServiceInterfaceClass((CodePrintWriter)out, (Names)names, methods);
        WriterUtil.writeContent((Names)names, (CodePrintWriter)out);
    }

    private static void writeServiceInterfaceClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", new Object[]{out.pkg()});
        out.println();
        out.format("%s", new Object[]{"IMPORTS_HERE"});
        WriterUtil.writeApiJavadoc((CodePrintWriter)out, (Names)names);
        WriterUtil.addGeneratedAnnotation((CodePrintWriter)out);
        out.line("public interface %s extends %s {", new Object[]{out.simpleClassName(), ErrorHandler.class});
        ServerCodeWriterSpringBoot.writeServiceMethods((CodePrintWriter)out, methods, (boolean)false, (Names)names);
        out.closeParen();
    }

    private static void writeServiceControllerClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", new Object[]{out.pkg()});
        out.println();
        out.format("%s", new Object[]{"IMPORTS_HERE"});
        out.println();
        out.line("@%s", new Object[]{RestController.class});
        WriterUtil.addGeneratedAnnotation((CodePrintWriter)out);
        out.line("public class %s implements %s {", new Object[]{out.simpleClassName(), ControllerExceptionHandler.class});
        out.println();
        out.line("private final %s service;", new Object[]{out.add(names.serviceInterfaceFullClassName())});
        out.println();
        out.line("public %s(@%s(required = false) %s service) {", new Object[]{out.simpleClassName(), Autowired.class, out.add(names.serviceInterfaceFullClassName())});
        out.line("this.service = %s.orElse(service, new %s() {});", new Object[]{org.davidmoten.oa3.codegen.util.Util.class, out.add(names.serviceInterfaceFullClassName())});
        out.closeParen();
        ServerCodeWriterSpringBoot.writeServiceMethods((CodePrintWriter)out, methods, (boolean)true, (Names)names);
        out.closeParen();
    }

    private static void writeServiceMethods(CodePrintWriter out, List<ClientServerGenerator.Method> methods, boolean isController, Names names) {
        methods.forEach(m -> {
            String importedReturnType;
            Optional<Object> returns = m.returnFullClassName.isPresent() ? m.primaryStatusCode.map(x -> "primary response status code " + x) : Optional.empty();
            ServerCodeWriterSpringBoot.writeMethodJavadoc((CodePrintWriter)out, (ClientServerGenerator.Method)m, returns, (Map)Maps.empty());
            out.right().right();
            String params = m.parameters.stream().map(p -> {
                String annotations;
                if (p.isRequestBody) {
                    String annotations2 = isController ? String.format("@%s ", out.add(RequestBody.class)) : "";
                    return String.format("\n%s%s%s %s", out.indent(), annotations2, ServerCodeWriterSpringBoot.toImportedType((ClientServerGenerator.Param)p, (Imports)out.imports()), "requestBody");
                }
                if (isController) {
                    String defValue = p.defaultValue.map(x -> ", defaultValue = \"" + x + "\"").orElse("");
                    String required = ", required = " + p.required;
                    Class<ModelAttribute> ann = ServerCodeWriterSpringBoot.annotation((ParamType)p.type);
                    if (ann.equals(RequestParam.class) && p.isComplexQueryParameter) {
                        ann = ModelAttribute.class;
                        required = "";
                        defValue = "";
                    }
                    annotations = String.format("@%s(name = \"%s\"%s%s) ", out.add(ann), p.name, defValue, required);
                } else {
                    annotations = "";
                }
                return String.format("\n%s%s%s %s", out.indent(), annotations, ServerCodeWriterSpringBoot.toImportedType((ClientServerGenerator.Param)p, (Imports)out.imports()), p.identifier);
            }).collect(Collectors.joining(", "));
            out.left().left();
            if (isController) {
                importedReturnType = String.format("%s<?>", out.add(ResponseEntity.class));
            } else if (!m.returnFullClassName.isPresent()) {
                importedReturnType = "void";
            } else {
                String fullClassName = m.returnFullClassName.orElse("").equals(byte[].class.getCanonicalName()) ? Resource.class.getCanonicalName() : (String)m.returnFullClassName.get();
                importedReturnType = out.add(fullClassName);
            }
            if (isController) {
                String produces;
                out.line("@%s(", new Object[]{RequestMapping.class});
                out.right();
                String consumes = m.consumes.stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
                if (!consumes.isEmpty()) {
                    consumes = String.format(",\n%sconsumes = {%s}", out.indent(), consumes);
                }
                if (!(produces = m.produces.stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", "))).isEmpty()) {
                    produces = String.format(",\n%sproduces = {%s}", out.indent(), produces);
                }
                out.line("method = %s.%s,", new Object[]{RequestMethod.class, m.httpMethod});
                out.line("value = \"%s\"%s%s)", new Object[]{m.path, consumes, produces});
                out.left();
                out.line("public %s %s(%s) {", new Object[]{importedReturnType, m.methodName, params});
                out.line("try {", new Object[0]);
                ServerCodeWriterSpringBoot.addValidationChecks((CodePrintWriter)out, (ClientServerGenerator.Method)m, (Names)names);
                if (m.returnFullClassName.isPresent()) {
                    out.line("return %s.status(%s).body(service.%s(%s));", new Object[]{ResponseEntity.class, m.statusCodeFirstInRange().orElse(200), m.methodName, m.parameters.stream().map(p -> p.identifier).collect(Collectors.joining(", "))});
                } else {
                    out.line("service.%s(%s);", new Object[]{m.methodName, m.parameters.stream().map(p -> p.identifier).collect(Collectors.joining(", "))});
                    out.line("return %s.status(%s).build();", new Object[]{ResponseEntity.class, m.statusCodeFirstInRange().orElse(200)});
                }
                out.left();
                out.line("} catch (%s e) {", new Object[]{Throwable.class});
                out.line("return service.errorResponse(e);", new Object[0]);
                out.closeParen();
                out.closeParen();
            } else {
                out.line("default %s %s(%s) throws %s {", new Object[]{importedReturnType, m.methodName, params, ServiceException.class});
                out.line("throw notImplemented();", new Object[0]);
                out.closeParen();
            }
        });
    }

    static void writeMethodJavadoc(CodePrintWriter out, ClientServerGenerator.Method m, Optional<String> returns, Map<String, String> throwing) {
        Map<String, String> parameterDescriptions = m.parameters.stream().collect(Collectors.toMap(x -> x.identifier, x -> WriterUtil.markdownToHtml((String)x.description.orElse(x.identifier))));
        String html = m.description.map(x -> WriterUtil.markdownToHtml((String)x)).orElse("<p>Returns response from call to path <i>%s</i>.</p>");
        String more = m.responseDescriptors.stream().map(rd -> {
            String full = rd.fullClassName();
            String link = Util.isPrimitiveFullClassName((String)full) || full.equals("byte[]") ? full : String.format("{@link %s}", out.add(full));
            return String.format("\n<p>[status=%s, %s] --&gt; %s</p>", rd.statusCode(), rd.mediaType(), link);
        }).collect(Collectors.joining());
        if (!Javadoc.printJavadoc((CodePrintWriter)out, Optional.of(html + more), Collections.emptyList(), Optional.empty(), returns, parameterDescriptions, (boolean)true, throwing)) {
            out.println();
        }
    }

    private static Class<?> annotation(ParamType t) {
        if (t == ParamType.BODY) {
            return RequestBody.class;
        }
        if (t == ParamType.QUERY) {
            return RequestParam.class;
        }
        if (t == ParamType.PATH) {
            return PathVariable.class;
        }
        if (t == ParamType.HEADER) {
            return RequestHeader.class;
        }
        if (t == ParamType.COOKIE) {
            return CookieValue.class;
        }
        throw new IllegalArgumentException("unexpected " + t);
    }

    private static void addValidationChecks(CodePrintWriter out, ClientServerGenerator.Method m, Names names) {
        boolean found = m.parameters.stream().anyMatch(p -> p.constraints.atLeastOnePresent());
        if (found) {
            out.line("if (%s.config().validateInControllerMethod().test(\"%s\")) {", new Object[]{out.add(names.globalsFullClassName()), m.methodName});
            m.parameters.forEach(p -> {
                ClientServerGenerator.Constraints x = p.constraints;
                if (x.atLeastOnePresent()) {
                    if (x.minLength.isPresent()) {
                        out.line("%s.checkMinLength(%s, %s, \"%s\");", new Object[]{RequestPreconditions.class, p.identifier, x.minLength.get(), p.identifier});
                    }
                    if (x.maxLength.isPresent()) {
                        out.line("%s.checkMaxLength(%s, %s, \"%s\");", new Object[]{RequestPreconditions.class, p.identifier, x.maxLength.get(), p.identifier});
                    }
                    if (x.pattern.isPresent()) {
                        out.line("%s.checkMatchesPattern(%s, \"%s\", \"%s\");", new Object[]{RequestPreconditions.class, p.identifier, WriterUtil.escapePattern((String)((String)x.pattern.get())), p.identifier});
                    }
                    if (x.min.isPresent()) {
                        out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", new Object[]{RequestPreconditions.class, p.identifier, ((BigDecimal)x.min.get()).toString(), p.identifier, false});
                    }
                    if (x.max.isPresent()) {
                        out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", new Object[]{RequestPreconditions.class, p.identifier, ((BigDecimal)x.max.get()).toString(), p.identifier, false});
                    }
                    if (x.minExclusive.isPresent()) {
                        out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", new Object[]{RequestPreconditions.class, p.identifier, ((BigDecimal)x.minExclusive.get()).toString(), p.identifier, true});
                    }
                    if (x.maxExclusive.isPresent()) {
                        out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", new Object[]{RequestPreconditions.class, p.identifier, ((BigDecimal)x.maxExclusive.get()).toString(), p.identifier, true});
                    }
                    if (p.isArray && x.minItems.isPresent()) {
                        out.line("%s.checkMinSize(%s, %s, \"%s\");", new Object[]{RequestPreconditions.class, p.identifier, x.minItems.get(), p.identifier});
                    }
                    if (p.isArray && x.maxItems.isPresent()) {
                        out.line("%s.checkMaxSize(%s, %s, \"%s\");", new Object[]{RequestPreconditions.class, p.identifier, x.maxItems.get(), p.identifier});
                    }
                }
            });
            out.closeParen();
        }
    }

    static String toImportedType(ClientServerGenerator.Param p, Imports imports) {
        if (p.isArray) {
            if (p.required) {
                return String.format("%s<%s>", imports.add(List.class), imports.add(p.fullClassName));
            }
            return String.format("%s<%s<%s>>", imports.add(Optional.class), imports.add(List.class), imports.add(p.fullClassName));
        }
        if (p.required || p.defaultValue.isPresent()) {
            return imports.add(Util.toPrimitive((String)p.fullClassName));
        }
        return String.format("%s<%s>", imports.add(Optional.class), imports.add(p.fullClassName));
    }
}

