/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.github.davidmoten.guavamini.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.client.runtime.ClientBuilder;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.generator.writer.ServerCodeWriterSpringBoot;
import org.davidmoten.oa3.codegen.http.Http;
import org.davidmoten.oa3.codegen.http.HttpMethod;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.MediaType;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.http.service.HttpService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientCodeWriter {
    public static void writeClientClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.clientFullClassName();
        CodePrintWriter out = CodePrintWriter.create((String)fullClassName, (Predicate)names.simpleNameInPackage(fullClassName));
        ClientCodeWriter.writeClientClass((CodePrintWriter)out, (Names)names, methods);
        WriterUtil.writeContent((Names)names, (CodePrintWriter)out);
    }

    private static void writeClientClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", new Object[]{out.pkg()});
        out.println();
        out.format("%s", new Object[]{"IMPORTS_HERE"});
        WriterUtil.writeApiJavadoc((CodePrintWriter)out, (Names)names);
        WriterUtil.addGeneratedAnnotation((CodePrintWriter)out);
        out.line("public class %s {", new Object[]{out.simpleClassName()});
        ClientCodeWriter.writeClientClassFieldsConstructorAndBuilder((CodePrintWriter)out, (Names)names);
        ClientCodeWriter.writeClientUtilityMethods((CodePrintWriter)out);
        ClientCodeWriter.writeClientClassMethods((CodePrintWriter)out, methods);
        ClientCodeWriter.writeCustomMethod((CodePrintWriter)out);
        out.closeParen();
    }

    private static void writeClientClassFieldsConstructorAndBuilder(CodePrintWriter out, Names names) {
        out.println();
        out.line("private final %s serializer;", new Object[]{Serializer.class});
        out.line("private final %s<%s> interceptors;", new Object[]{List.class, Interceptor.class});
        out.line("private final %s basePath;", new Object[]{String.class});
        out.line("private final %s httpService;", new Object[]{HttpService.class});
        out.println();
        out.line("private %s(%s serializer, %s<%s> interceptors, %s basePath, %s httpService) {", new Object[]{out.simpleClassName(), Serializer.class, List.class, Interceptor.class, String.class, HttpService.class});
        out.line("this.serializer = serializer;", new Object[0]);
        out.line("this.interceptors = interceptors;", new Object[0]);
        out.line("this.basePath = basePath;", new Object[0]);
        out.line("this.httpService = httpService;", new Object[0]);
        out.closeParen();
        out.println();
        out.line("public static %s<%s> basePath(%s basePath) {", new Object[]{ClientBuilder.class, out.simpleClassName(), String.class});
        out.line("return new %s<>(b -> new %s(b.serializer(), b.interceptors(), b.basePath(), b.httpService()), %s.config(), basePath);", new Object[]{ClientBuilder.class, out.simpleClassName(), out.add(names.globalsFullClassName())});
        out.closeParen();
    }

    private static void writeClientUtilityMethods(CodePrintWriter out) {
        out.println();
        out.line("private %s http(%s method, %s path) {", new Object[]{Http.Builder.class, HttpMethod.class, String.class});
        out.line("return %s", new Object[]{Http.class});
        out.right();
        out.right();
        out.line(".method(method)", new Object[0]);
        out.line(".basePath(this.basePath)", new Object[0]);
        out.line(".path(path)", new Object[0]);
        out.line(".serializer(this.serializer)", new Object[0]);
        out.line(".interceptors(this.interceptors)", new Object[0]);
        out.line(".httpService(this.httpService);", new Object[0]);
        out.left();
        out.left();
        out.closeParen();
    }

    private static void writeClientClassMethods(CodePrintWriter out, List<ClientServerGenerator.Method> methods) {
        methods.forEach(m -> {
            out.right().right();
            String params = m.parameters.stream().map(p -> String.format("\n%s%s %s", out.indent(), ServerCodeWriterSpringBoot.toImportedType((ClientServerGenerator.Param)p, (Imports)out.imports()), p.identifier)).collect(Collectors.joining(", "));
            out.left().left();
            String importedReturnType = !m.returnFullClassName.isPresent() ? out.add(Void.class.getCanonicalName()) : out.add((String)m.returnFullClassName.get());
            boolean hasPrimaryResponse = m.primaryStatusCode.isPresent() && m.primaryMediaType.isPresent();
            ServerCodeWriterSpringBoot.writeMethodJavadoc((CodePrintWriter)out, (ClientServerGenerator.Method)m, Optional.of("call builder"), (Map)Maps.empty());
            out.line("public %s<%s> %s(%s) {", new Object[]{Http.RequestBuilder.class, importedReturnType, m.methodName, params});
            out.line("return http(%s.%s, \"%s\")", new Object[]{HttpMethod.class, m.httpMethod.name(), m.path});
            out.right().right();
            HashSet<String> used = new HashSet<String>();
            for (ClientServerGenerator.ResponseDescriptor rd : m.responseDescriptors) {
                if (used.contains(rd.mediaType())) continue;
                if (MediaType.isJson((String)rd.mediaType())) {
                    out.line(".acceptApplicationJson()", new Object[0]);
                } else {
                    out.line(".accept(\"%s\")", new Object[]{rd.mediaType()});
                }
                used.add(rd.mediaType());
            }
            m.parameters.forEach(p -> {
                if (p.type == ParamType.QUERY) {
                    out.line(".queryParam(\"%s\", %s)", new Object[]{p.name, p.identifier});
                } else if (p.type == ParamType.PATH) {
                    out.line(".pathParam(\"%s\", %s)", new Object[]{p.name, p.identifier});
                } else if (p.type == ParamType.BODY) {
                    out.line(".body(%s)", new Object[]{p.identifier});
                    out.line(".contentTypeApplicationJson()", new Object[0]);
                } else if (p.type == ParamType.COOKIE) {
                    out.line(".cookie(\"%s\", %s)", new Object[]{p.name, p.identifier});
                } else if (p.type == ParamType.HEADER) {
                    out.line(".header(\"%s\", %s)", new Object[]{p.name, p.identifier});
                } else if (p.type == ParamType.MULTIPART_FORM_DATA) {
                    out.line(".multipartFormData(%s)", new Object[]{p.identifier});
                } else if (p.type == ParamType.FORM_URLENCODED) {
                    out.line(".formUrlEncoded(%s)", new Object[]{p.identifier});
                }
            });
            m.responseDescriptors.forEach(r -> {
                out.line(".responseAs(%s.class)", new Object[]{out.add(r.fullClassName())});
                out.line(".whenStatusCodeMatches(\"%s\")", new Object[]{r.statusCode()});
                out.line(".whenContentTypeMatches(\"%s\")", new Object[]{r.mediaType()});
            });
            if (hasPrimaryResponse) {
                out.line(".<%s>requestBuilder(\"%s\", \"%s\");", new Object[]{importedReturnType, m.primaryStatusCode.get(), m.primaryMediaType.get()});
            } else {
                out.line(".<%s>requestBuilder();", new Object[]{importedReturnType});
            }
            out.left().left();
            out.closeParen();
        });
    }

    private static void writeCustomMethod(CodePrintWriter out) {
        out.println();
        out.line("public %s _custom(%s method, %s path) {", new Object[]{Http.Builder.class, HttpMethod.class, String.class});
        out.line("return %s", new Object[]{Http.class});
        out.right().right();
        out.line(".method(method)", new Object[0]);
        out.line(".basePath(this.basePath)", new Object[0]);
        out.line(".path(path)", new Object[0]);
        out.line(".serializer(this.serializer)", new Object[0]);
        out.line(".httpService(this.httpService);", new Object[0]);
        out.left().left();
        out.closeParen();
    }
}

