/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import jakarta.annotation.Generated;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WriterUtil {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("debug", "false"));
    public static final String IMPORTS_HERE = "IMPORTS_HERE";
    public static final String GROUP_ID_ARTIFACT_ID_VERSION = WriterUtil.readMavenCoordinates();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMavenCoordinates() {
        Properties p = new Properties();
        try (InputStream in = Generator.class.getResourceAsStream("/application.properties");){
            p.load(in);
            String string = p.get("groupId") + ":" + p.get("artifactId") + ":" + p.get("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readVersion() {
        Properties p = new Properties();
        try (InputStream in = Generator.class.getResourceAsStream("/application.properties");){
            p.load(in);
            String string = String.valueOf(p.get("version"));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void closeParen(PrintWriter out, Indent indent) {
        indent.left();
        out.format("%s}\n", indent);
    }

    public static void writeContent(Names names, CodePrintWriter out) {
        String content = out.text().replace("IMPORTS_HERE", out.imports().toString());
        if (DEBUG) {
            System.out.println("////////////////////////////////////////////////");
            System.out.println(content);
        }
        out.close();
        File file = names.fullClassNameToJavaFile(out.fullClassName());
        file.getParentFile().mkdirs();
        try {
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String markdownToHtml(String description) {
        Parser parser = Parser.builder().build();
        Node document = parser.parse(description);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return renderer.render(document);
    }

    public static void writeApiJavadoc(CodePrintWriter out, Names names) {
        String text = Stream.of(Optional.ofNullable(names.api().getInfo().getTitle()), Optional.ofNullable(names.api().getInfo().getSummary()), Optional.ofNullable(names.api().getInfo().getDescription())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        if (!Javadoc.printJavadoc((CodePrintWriter)out, (Indent)out.indent(), (String)WriterUtil.markdownToHtml((String)text), (boolean)true)) {
            out.println();
        }
    }

    public static void addGeneratedAnnotation(CodePrintWriter out) {
        out.line("@%s(value = \"%s\")", new Object[]{Generated.class, GROUP_ID_ARTIFACT_ID_VERSION});
    }

    public static String escapePattern(String pattern) {
        return pattern.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

