/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Apis;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaWithName;
import org.davidmoten.oa3.codegen.generator.Visitor;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.writer.SchemasCodeWriter;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.util.ImmutableList;

/*
 * Exception performing whole class analysis ignored.
 */
public class Generator {
    private final Definition definition;
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Sets.of((Object[])new String[]{"int", "long", "byte", "float", "double", "boolean", "short"});

    public Generator(Definition definition) {
        this.definition = definition;
    }

    public void generate() {
        Names names = new Names(this.definition);
        Generator.writeSchemaClasses((Definition)this.definition, (Names)names);
        SchemasCodeWriter.writeGlobalsClass((Names)names);
    }

    private static void writeSchemaClasses(Definition definition, Names names) {
        MyVisitor v = new MyVisitor(names);
        Apis.visitSchemas((OpenAPI)names.api(), (Visitor)v);
        for (MyVisitor.Result result : v.results()) {
            Cls cls = result.cls;
            String schemaName = result.name;
            if (!definition.includeSchemas().isEmpty() && !definition.includeSchemas().contains(schemaName) || definition.excludeSchemas().contains(schemaName)) continue;
            names.registerCls(cls);
        }
        HashMap fullClassNameInterfaces = new HashMap();
        for (MyVisitor.Result result : v.results()) {
            Generator.findFullClassNameInterfaces((Cls)result.cls, fullClassNameInterfaces);
        }
        for (MyVisitor.Result result : v.results()) {
            Cls cls = result.cls;
            String schemaName = result.name;
            if (!definition.includeSchemas().isEmpty() && !definition.includeSchemas().contains(schemaName) || definition.excludeSchemas().contains(schemaName)) continue;
            SchemasCodeWriter.writeSchemaClass((Names)names, fullClassNameInterfaces, (Cls)cls, (String)schemaName);
        }
    }

    private static void findFullClassNameInterfaces(Cls cls, Map<String, Set<Cls>> fullClassNameInterfaces) {
        if (cls.classType == ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            cls.fields.forEach(x -> {
                HashSet<Cls> list = (HashSet<Cls>)fullClassNameInterfaces.get(x.fullClassName);
                if (list == null) {
                    list = new HashSet<Cls>();
                    fullClassNameInterfaces.put(x.fullClassName, list);
                }
                list.add(cls);
            });
        }
    }

    private static Optional<Object> extension(Schema<?> schema, String key) {
        Preconditions.checkNotNull((Object)key);
        Map map = schema.getExtensions();
        if (map == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(map.get(key));
    }

    public static Optional<String> extensionString(Schema<?> schema, String key) {
        return Generator.extension(schema, (String)key);
    }

    private static boolean isNullable(Schema<?> schema) {
        return Boolean.TRUE.equals(schema.getNullable()) || schema.getTypes() != null && schema.getTypes().contains("null");
    }

    private static Encoding encoding(Schema<?> schema) {
        if ("binary".equals(schema.getFormat())) {
            return Encoding.OCTET;
        }
        return Encoding.DEFAULT;
    }

    private static void updateLinks(Cls cls, Optional<Cls> previous) {
        previous.ifPresent(p -> {
            p.classes.add(cls);
            cls.owner = Optional.of(p);
        });
    }

    private static void handleObject(ImmutableList<SchemaWithName> schemaPath, SchemaWithName last, Schema<?> schema, Cls cls, boolean isArray, Optional<Cls> previous, Optional<String> fieldName) {
        cls.classType = ClassType.CLASS;
        cls.hasProperties = Util.isObject(schema);
        if (!cls.schema.isPresent()) {
            cls.schema = Optional.of(schema);
        }
        boolean required = Generator.fieldIsRequired(schemaPath);
        Optional mt = Generator.mapType(schemaPath);
        if (mt.isPresent() && mt.get() == MapType.FIELD) {
            mt = Optional.empty();
        }
        Optional mt2 = mt;
        previous.ifPresent(p -> p.addField(cls.fullClassName, last.name, (String)fieldName.get(), required, isArray, mt2, Generator.isNullable((Schema)schema)));
    }

    private static boolean isString(Schema<?> schema) {
        return "string".equals(Util.getType(schema).orElse("object"));
    }

    private static boolean fieldIsRequired(ImmutableList<SchemaWithName> schemaPath) {
        SchemaWithName last = (SchemaWithName)schemaPath.last();
        if (schemaPath.size() <= 1) {
            return Util.isPrimitive((Schema)last.schema) || Util.isRef((Schema)last.schema) || Util.isArray((Schema)last.schema);
        }
        return Generator.contains((Collection)((SchemaWithName)schemaPath.secondLast()).schema.getRequired(), (Object)last.name) || Util.isAllOf((Schema)((SchemaWithName)schemaPath.secondLast()).schema) || Util.isArray((Schema)((SchemaWithName)schemaPath.secondLast()).schema) || Generator.mapType(schemaPath).equals(Optional.of(MapType.ADDITIONAL_PROPERTIES));
    }

    private static Optional<MapType> mapType(ImmutableList<SchemaWithName> schemaPath) {
        Schema schema = ((SchemaWithName)schemaPath.last()).schema;
        if (schemaPath.size() > 1 && ((SchemaWithName)schemaPath.secondLast()).schema.getAdditionalProperties() == ((SchemaWithName)schemaPath.last()).schema) {
            return Optional.of(MapType.ADDITIONAL_PROPERTIES);
        }
        if (Util.isMap((Schema)schema) || Generator.allNulls((Schema)schema)) {
            return Optional.of(MapType.FIELD);
        }
        return Optional.empty();
    }

    private static boolean allNulls(Schema<?> s) {
        return s.getClass().equals(Schema.class) && !Util.getType(s).isPresent() && s.getProperties() == null && s.getAdditionalProperties() == null && s.get$ref() == null && s.getAdditionalItems() == null;
    }

    private static void handlePolymorphism(ImmutableList<SchemaWithName> schemaPath, Cls cls, Names names, Optional<Cls> previous, Optional<String> fieldName, boolean isArray) {
        SchemaWithName last = (SchemaWithName)schemaPath.last();
        cls.polymorphicType = Generator.polymorphicType((Schema)last.schema);
        io.swagger.v3.oas.models.media.Discriminator discriminator = last.schema.getDiscriminator();
        if (discriminator != null) {
            String propertyName = discriminator.getPropertyName();
            Map<Object, Object> map = discriminator.getMapping() != null ? discriminator.getMapping().entrySet().stream().collect(Collectors.toMap(x -> names.refToFullClassName((String)x.getValue()), x -> (String)x.getKey())) : Collections.emptyMap();
            cls.discriminator = new Discriminator(propertyName, Names.toFieldName((String)propertyName), map);
        }
        cls.classType = cls.polymorphicType == PolymorphicType.ONE_OF || cls.polymorphicType == PolymorphicType.ANY_OF ? (discriminator != null ? ClassType.ONE_OR_ANY_OF_DISCRIMINATED : (cls.polymorphicType == PolymorphicType.ONE_OF ? ClassType.ONE_OF_NON_DISCRIMINATED : ClassType.ANY_OF_NON_DISCRIMINATED)) : ClassType.ALL_OF;
        boolean required = Generator.fieldIsRequired(schemaPath);
        previous.ifPresent(p -> p.addField(cls.fullClassName, last.name, (String)fieldName.get(), required, isArray, Generator.mapType((ImmutableList)schemaPath), Generator.isNullable((Schema)((SchemaWithName)schemaPath.last()).schema)));
    }

    private static PolymorphicType polymorphicType(Schema<?> schema) {
        PolymorphicType pt = Util.isOneOf(schema) ? PolymorphicType.ONE_OF : (Util.isAnyOf(schema) ? PolymorphicType.ANY_OF : PolymorphicType.ALL_OF);
        return pt;
    }

    private static void handleEnum(ImmutableList<SchemaWithName> schemaPath, Cls cls, Optional<Cls> previous, boolean isArray, Optional<String> fieldName, Names names) {
        Schema schema = ((SchemaWithName)schemaPath.last()).schema;
        cls.classType = ClassType.ENUM;
        if (!cls.schema.isPresent()) {
            cls.schema = Optional.of(schema);
        }
        Class valueCls = Util.toClass((String)Util.getTypeOrThrow((Schema)schema), (String)schema.getFormat(), (Map)schema.getExtensions(), (boolean)names.mapIntegerToBigInteger(), (boolean)names.mapNumberToBigDecimal());
        cls.enumValueFullType = valueCls.getCanonicalName();
        Map map = Names.getEnumValueToIdentifierMap((List)schema.getEnum());
        HashSet<String> used = new HashSet<String>();
        for (Object o : schema.getEnum()) {
            if (used.contains(String.valueOf(o))) continue;
            cls.enumMembers.add(new EnumMember((String)map.get(String.valueOf(o)), o, Generator.isNullable((Schema)schema)));
            used.add(String.valueOf(o));
        }
        if (schema.getExtensions() != null && schema.getExtensions().get("x-openapi-codegen-names") != null) {
            List a = (List)schema.getExtensions().get("x-openapi-codegen-names");
            if (a.size() == cls.enumMembers.size()) {
                cls.enumNames = a;
            } else {
                System.out.println("[WARN] x-openapi-codegen-names array length must match number of enum members");
            }
        }
        cls.addField(cls.enumValueFullType, "value", "value", true, false, Generator.mapType(schemaPath), Generator.isNullable((Schema)schema));
        boolean required = Generator.fieldIsRequired(schemaPath);
        previous.ifPresent(p -> p.addField(cls.fullClassName, ((SchemaWithName)schemaPath.last()).name, (String)fieldName.get(), required, isArray, Generator.mapType((ImmutableList)schemaPath), Generator.isNullable((Schema)schema)));
    }

    private static <T> boolean contains(Collection<? extends T> collection, T t) {
        return collection != null && t != null && collection.contains(t);
    }

    private static String toList(String fullClassName, Imports imports, boolean useOptional) {
        if (useOptional) {
            return String.format("%s<%s<%s>>", imports.add(Optional.class), imports.add(List.class), imports.add(fullClassName));
        }
        return String.format("%s<%s>", imports.add(List.class), imports.add(fullClassName));
    }

    private static String resolveCandidateFullClassName(Cls cls, String candidateFullClassName) {
        String s = candidateFullClassName;
        Set ownersAndSiblings = cls.ownersAndSiblingsSimpleNames();
        if (ownersAndSiblings.contains(Names.simpleClassName((String)s)) || s.equals(cls.fullClassName)) {
            int i = 2;
            while (ownersAndSiblings.contains(Names.simpleClassName((String)(s + i)))) {
                ++i;
            }
            s = s + i;
        }
        return s;
    }

    private static ClassType classType(Schema<?> schema) {
        if (Util.isOneOf(schema)) {
            return ClassType.ONE_OF_NON_DISCRIMINATED;
        }
        if (Util.isAnyOf(schema)) {
            return ClassType.ANY_OF_NON_DISCRIMINATED;
        }
        if (Util.isEnum(schema)) {
            return ClassType.ENUM;
        }
        if (Util.isArray(schema)) {
            return ClassType.ARRAY_WRAPPER;
        }
        return ClassType.CLASS;
    }

    static /* synthetic */ Optional access$000(Schema x0, String x1) {
        return Generator.extension((Schema)x0, (String)x1);
    }

    static /* synthetic */ String access$100(String x0, Imports x1, boolean x2) {
        return Generator.toList((String)x0, (Imports)x1, (boolean)x2);
    }

    static /* synthetic */ Set access$200() {
        return PRIMITIVE_CLASS_NAMES;
    }

    static /* synthetic */ ClassType access$300(Schema x0) {
        return Generator.classType((Schema)x0);
    }

    static /* synthetic */ void access$400(Cls x0, Optional x1) {
        Generator.updateLinks((Cls)x0, (Optional)x1);
    }

    static /* synthetic */ String access$500(Cls x0, String x1) {
        return Generator.resolveCandidateFullClassName((Cls)x0, (String)x1);
    }

    static /* synthetic */ boolean access$600(ImmutableList x0) {
        return Generator.fieldIsRequired((ImmutableList)x0);
    }

    static /* synthetic */ void access$700(ImmutableList x0, Cls x1, Optional x2, boolean x3, Optional x4, Names x5) {
        Generator.handleEnum((ImmutableList)x0, (Cls)x1, (Optional)x2, (boolean)x3, (Optional)x4, (Names)x5);
    }

    static /* synthetic */ void access$800(ImmutableList x0, SchemaWithName x1, Schema x2, Cls x3, boolean x4, Optional x5, Optional x6) {
        Generator.handleObject((ImmutableList)x0, (SchemaWithName)x1, (Schema)x2, (Cls)x3, (boolean)x4, (Optional)x5, (Optional)x6);
    }

    static /* synthetic */ void access$900(ImmutableList x0, Cls x1, Names x2, Optional x3, Optional x4, boolean x5) {
        Generator.handlePolymorphism((ImmutableList)x0, (Cls)x1, (Names)x2, (Optional)x3, (Optional)x4, (boolean)x5);
    }

    static /* synthetic */ boolean access$1000(Schema x0) {
        return Generator.isString((Schema)x0);
    }

    static /* synthetic */ Encoding access$1100(Schema x0) {
        return Generator.encoding((Schema)x0);
    }

    static /* synthetic */ Optional access$1200(ImmutableList x0) {
        return Generator.mapType((ImmutableList)x0);
    }

    static /* synthetic */ boolean access$1300(Schema x0) {
        return Generator.isNullable((Schema)x0);
    }
}

