/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.client.runtime;

import java.util.function.Function;
import org.davidmoten.oa3.codegen.http.DefaultSerializer;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.runtime.Config;

public final class ClientBuilder<T> {
    private final Function<ClientBuilder<T>, T> creator;
    private final String basePath;
    private Serializer serializer;
    private Interceptor interceptor;

    public ClientBuilder(Function<ClientBuilder<T>, T> creator, Config config, String basePath) {
        this.creator = creator;
        this.serializer = new DefaultSerializer(config.mapper());
        this.interceptor = x -> x;
        this.basePath = ClientBuilder.trimAndRemoveFinalSlash(basePath);
    }

    public ClientBuilder<T> serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ClientBuilder<T> interceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Interceptor interceptor() {
        return this.interceptor;
    }

    public String basePath() {
        return this.basePath;
    }

    public T build() {
        return this.creator.apply(this);
    }

    private static String trimAndRemoveFinalSlash(String s) {
        if ((s = s.trim()).endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }
}

