package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RequestedDeploymentStateValue implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("paused")
    PAUSED("paused", "1"),

    @JsonProperty("archived")
    ARCHIVED("archived", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private RequestedDeploymentStateValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
