package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AzureADDeviceRegistrationErrorReason implements Enum {

    @JsonProperty("invalidGlobalDeviceId")
    INVALID_GLOBAL_DEVICE_ID("invalidGlobalDeviceId", "0"),

    @JsonProperty("invalidAzureADDeviceId")
    INVALID_AZURE_ADDEVICE_ID("invalidAzureADDeviceId", "1"),

    @JsonProperty("missingTrustType")
    MISSING_TRUST_TYPE("missingTrustType", "2"),

    @JsonProperty("invalidAzureADJoin")
    INVALID_AZURE_ADJOIN("invalidAzureADJoin", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private AzureADDeviceRegistrationErrorReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
