package odata.msgraph.client.beta.windows.updates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.Updates;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.DeploymentCollectionRequest;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.UpdatableAssetCollectionRequest;

@JsonIgnoreType
public class UpdatesRequest extends EntityRequest<Updates> {

    public UpdatesRequest(ContextPath contextPath, Optional<Object> value) {
        super(Updates.class, contextPath, value, false);
    }

    public CatalogRequest catalog() {
        return new CatalogRequest(contextPath.addSegment("catalog"), Optional.empty());
    }

    public DeploymentRequest deployments(String id) {
        return new DeploymentRequest(contextPath.addSegment("deployments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeploymentCollectionRequest deployments() {
        return new DeploymentCollectionRequest(
                        contextPath.addSegment("deployments"), Optional.empty());
    }

    public UpdatableAssetRequest updatableAssets(String id) {
        return new UpdatableAssetRequest(contextPath.addSegment("updatableAssets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UpdatableAssetCollectionRequest updatableAssets() {
        return new UpdatableAssetCollectionRequest(
                        contextPath.addSegment("updatableAssets"), Optional.empty());
    }

}
