package odata.msgraph.client.beta.windows.updates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.DeploymentAudience;
import odata.msgraph.client.beta.windows.updates.entity.UpdatableAsset;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.UpdatableAssetCollectionRequest;

@JsonIgnoreType
public class DeploymentAudienceRequest extends EntityRequest<DeploymentAudience> {

    public DeploymentAudienceRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeploymentAudience.class, contextPath, value, false);
    }

    public UpdatableAssetRequest exclusions(String id) {
        return new UpdatableAssetRequest(contextPath.addSegment("exclusions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UpdatableAssetCollectionRequest exclusions() {
        return new UpdatableAssetCollectionRequest(
                        contextPath.addSegment("exclusions"), Optional.empty());
    }

    public UpdatableAssetRequest members(String id) {
        return new UpdatableAssetRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UpdatableAssetCollectionRequest members() {
        return new UpdatableAssetCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    @Action(name = "updateAudience")
    @JsonIgnore
    public ActionRequestNoReturn updateAudience(List<UpdatableAsset> addMembers, List<UpdatableAsset> removeMembers, List<UpdatableAsset> addExclusions, List<UpdatableAsset> removeExclusions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addMembers", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", addMembers)
            .put("removeMembers", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", removeMembers)
            .put("addExclusions", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", addExclusions)
            .put("removeExclusions", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", removeExclusions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.updateAudience"), _parameters);
    }

    @Action(name = "updateAudienceById")
    @JsonIgnore
    public ActionRequestNoReturn updateAudienceById(String memberEntityType, List<String> addMembers, List<String> removeMembers, List<String> addExclusions, List<String> removeExclusions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("memberEntityType", "Edm.String", Checks.checkIsAscii(memberEntityType))
            .put("addMembers", "Collection(Edm.String)", Checks.checkIsAscii(addMembers))
            .put("removeMembers", "Collection(Edm.String)", Checks.checkIsAscii(removeMembers))
            .put("addExclusions", "Collection(Edm.String)", Checks.checkIsAscii(addExclusions))
            .put("removeExclusions", "Collection(Edm.String)", Checks.checkIsAscii(removeExclusions))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.updateAudienceById"), _parameters);
    }

}
