package odata.msgraph.client.beta.windows.updates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.Catalog;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.CatalogEntryCollectionRequest;

@JsonIgnoreType
public class CatalogRequest extends EntityRequest<Catalog> {

    public CatalogRequest(ContextPath contextPath, Optional<Object> value) {
        super(Catalog.class, contextPath, value, false);
    }

    public CatalogEntryRequest entries(String id) {
        return new CatalogEntryRequest(contextPath.addSegment("entries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CatalogEntryCollectionRequest entries() {
        return new CatalogEntryCollectionRequest(
                        contextPath.addSegment("entries"), Optional.empty());
    }

}
