package odata.msgraph.client.beta.windows.updates.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.UpdatableAsset;
import odata.msgraph.client.beta.windows.updates.entity.request.UpdatableAssetRequest;
import odata.msgraph.client.beta.windows.updates.enums.UpdateCategory;

public class UpdatableAssetCollectionRequest extends CollectionPageEntityRequest<UpdatableAsset, UpdatableAssetRequest>{

    protected ContextPath contextPath;

    public UpdatableAssetCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UpdatableAsset.class, cp -> new UpdatableAssetRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "enrollAssets")
    @JsonIgnore
    public ActionRequestNoReturn enrollAssets(UpdateCategory updateCategory, List<UpdatableAsset> assets) {
        Preconditions.checkNotNull(updateCategory, "updateCategory cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateCategory", "microsoft.graph.windowsUpdates.updateCategory", updateCategory)
            .put("assets", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", assets)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.enrollAssets"), _parameters);
    }

    @Action(name = "enrollAssetsById")
    @JsonIgnore
    public ActionRequestNoReturn enrollAssetsById(UpdateCategory updateCategory, String memberEntityType, List<String> ids) {
        Preconditions.checkNotNull(updateCategory, "updateCategory cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateCategory", "microsoft.graph.windowsUpdates.updateCategory", updateCategory)
            .put("memberEntityType", "Edm.String", Checks.checkIsAscii(memberEntityType))
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.enrollAssetsById"), _parameters);
    }

    @Action(name = "unenrollAssets")
    @JsonIgnore
    public ActionRequestNoReturn unenrollAssets(UpdateCategory updateCategory, List<UpdatableAsset> assets) {
        Preconditions.checkNotNull(updateCategory, "updateCategory cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateCategory", "microsoft.graph.windowsUpdates.updateCategory", updateCategory)
            .put("assets", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", assets)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.unenrollAssets"), _parameters);
    }

    @Action(name = "unenrollAssetsById")
    @JsonIgnore
    public ActionRequestNoReturn unenrollAssetsById(UpdateCategory updateCategory, String memberEntityType, List<String> ids) {
        Preconditions.checkNotNull(updateCategory, "updateCategory cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateCategory", "microsoft.graph.windowsUpdates.updateCategory", updateCategory)
            .put("memberEntityType", "Edm.String", Checks.checkIsAscii(memberEntityType))
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.unenrollAssetsById"), _parameters);
    }

}
