package odata.msgraph.client.beta.windows.updates.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.windows.updates.complex.DeployableContent;
import odata.msgraph.client.beta.windows.updates.complex.DeploymentSettings;
import odata.msgraph.client.beta.windows.updates.complex.DeploymentState;
import odata.msgraph.client.beta.windows.updates.entity.request.DeploymentAudienceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "settings", 
    "state", 
    "audience"})
@JsonInclude(Include.NON_NULL)
public class Deployment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.deployment";
    }

    @JsonProperty("content")
    protected DeployableContent content;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("settings")
    protected DeploymentSettings settings;

    @JsonProperty("state")
    protected DeploymentState state;

    @JsonProperty("audience")
    protected DeploymentAudience audience;

    protected Deployment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeployment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeployableContent content;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private DeploymentSettings settings;
        private DeploymentState state;
        private DeploymentAudience audience;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder content(DeployableContent content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder settings(DeploymentSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder state(DeploymentState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder audience(DeploymentAudience audience) {
            this.audience = audience;
            this.changedFields = changedFields.add("audience");
            return this;
        }

        public Deployment build() {
            Deployment _x = new Deployment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.deployment";
            _x.id = id;
            _x.content = content;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.settings = settings;
            _x.state = state;
            _x.audience = audience;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<DeployableContent> getContent() {
        return Optional.ofNullable(content);
    }

    public Deployment withContent(DeployableContent content) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.content = content;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Deployment withCreatedDateTime(OffsetDateTime createdDateTime) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Deployment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<DeploymentSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public Deployment withSettings(DeploymentSettings settings) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.settings = settings;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<DeploymentState> getState() {
        return Optional.ofNullable(state);
    }

    public Deployment withState(DeploymentState state) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.state = state;
        return _x;
    }

    public Deployment withUnmappedField(String name, Object value) {
        Deployment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="audience")
    @JsonIgnore
    public DeploymentAudienceRequest getAudience() {
        return new DeploymentAudienceRequest(contextPath.addSegment("audience"), Optional.ofNullable(audience));
    }

    public Deployment withAudience(DeploymentAudience audience) {
        Deployment _x = _copy();
        _x.changedFields = changedFields.add("audience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deployment");
        _x.audience = audience;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Deployment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Deployment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Deployment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Deployment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Deployment _copy() {
        Deployment _x = new Deployment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.content = content;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.settings = settings;
        _x.state = state;
        _x.audience = audience;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Deployment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("audience=");
        b.append(this.audience);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
