package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "daysUntilForcedReboot"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("daysUntilForcedReboot")
    protected Integer daysUntilForcedReboot;

    protected UserExperienceSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.userExperienceSettings";
    }

    @Property(name="daysUntilForcedReboot")
    @JsonIgnore
    public Optional<Integer> getDaysUntilForcedReboot() {
        return Optional.ofNullable(daysUntilForcedReboot);
    }

    public UserExperienceSettings withDaysUntilForcedReboot(Integer daysUntilForcedReboot) {
        UserExperienceSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.userExperienceSettings");
        _x.daysUntilForcedReboot = daysUntilForcedReboot;
        return _x;
    }

    public UserExperienceSettings withUnmappedField(String name, Object value) {
        UserExperienceSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer daysUntilForcedReboot;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder daysUntilForcedReboot(Integer daysUntilForcedReboot) {
            this.daysUntilForcedReboot = daysUntilForcedReboot;
            this.changedFields = changedFields.add("daysUntilForcedReboot");
            return this;
        }

        public UserExperienceSettings build() {
            UserExperienceSettings _x = new UserExperienceSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.userExperienceSettings";
            _x.daysUntilForcedReboot = daysUntilForcedReboot;
            return _x;
        }
    }

    private UserExperienceSettings _copy() {
        UserExperienceSettings _x = new UserExperienceSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.daysUntilForcedReboot = daysUntilForcedReboot;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceSettings[");
        b.append("daysUntilForcedReboot=");
        b.append(this.daysUntilForcedReboot);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
