package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "devicesPerOffer", 
    "durationBetweenOffers", 
    "endDateTime", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class RolloutSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("devicesPerOffer")
    protected Integer devicesPerOffer;

    @JsonProperty("durationBetweenOffers")
    protected String durationBetweenOffers;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected RolloutSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.rolloutSettings";
    }

    @Property(name="devicesPerOffer")
    @JsonIgnore
    public Optional<Integer> getDevicesPerOffer() {
        return Optional.ofNullable(devicesPerOffer);
    }

    public RolloutSettings withDevicesPerOffer(Integer devicesPerOffer) {
        RolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.rolloutSettings");
        _x.devicesPerOffer = devicesPerOffer;
        return _x;
    }

    @Property(name="durationBetweenOffers")
    @JsonIgnore
    public Optional<String> getDurationBetweenOffers() {
        return Optional.ofNullable(durationBetweenOffers);
    }

    public RolloutSettings withDurationBetweenOffers(String durationBetweenOffers) {
        RolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.rolloutSettings");
        _x.durationBetweenOffers = durationBetweenOffers;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public RolloutSettings withEndDateTime(OffsetDateTime endDateTime) {
        RolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.rolloutSettings");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public RolloutSettings withStartDateTime(OffsetDateTime startDateTime) {
        RolloutSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.rolloutSettings");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public RolloutSettings withUnmappedField(String name, Object value) {
        RolloutSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer devicesPerOffer;
        private String durationBetweenOffers;
        private OffsetDateTime endDateTime;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder devicesPerOffer(Integer devicesPerOffer) {
            this.devicesPerOffer = devicesPerOffer;
            this.changedFields = changedFields.add("devicesPerOffer");
            return this;
        }

        public Builder durationBetweenOffers(String durationBetweenOffers) {
            this.durationBetweenOffers = durationBetweenOffers;
            this.changedFields = changedFields.add("durationBetweenOffers");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public RolloutSettings build() {
            RolloutSettings _x = new RolloutSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.rolloutSettings";
            _x.devicesPerOffer = devicesPerOffer;
            _x.durationBetweenOffers = durationBetweenOffers;
            _x.endDateTime = endDateTime;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private RolloutSettings _copy() {
        RolloutSettings _x = new RolloutSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.devicesPerOffer = devicesPerOffer;
        _x.durationBetweenOffers = durationBetweenOffers;
        _x.endDateTime = endDateTime;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RolloutSettings[");
        b.append("devicesPerOffer=");
        b.append(this.devicesPerOffer);
        b.append(", ");
        b.append("durationBetweenOffers=");
        b.append(this.durationBetweenOffers);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
