package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.QualityUpdateClassification;

@JsonPropertyOrder({
    "@odata.type", 
    "classification", 
    "releaseDateTime"})
@JsonInclude(Include.NON_NULL)
public class QualityUpdateReference extends WindowsUpdateReference implements ODataType {

    @JsonProperty("classification")
    protected QualityUpdateClassification classification;

    @JsonProperty("releaseDateTime")
    protected OffsetDateTime releaseDateTime;

    protected QualityUpdateReference() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.qualityUpdateReference";
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<QualityUpdateClassification> getClassification() {
        return Optional.ofNullable(classification);
    }

    public QualityUpdateReference withClassification(QualityUpdateClassification classification) {
        QualityUpdateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.qualityUpdateReference");
        _x.classification = classification;
        return _x;
    }

    @Property(name="releaseDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleaseDateTime() {
        return Optional.ofNullable(releaseDateTime);
    }

    public QualityUpdateReference withReleaseDateTime(OffsetDateTime releaseDateTime) {
        QualityUpdateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.qualityUpdateReference");
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    public QualityUpdateReference withUnmappedField(String name, Object value) {
        QualityUpdateReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQualityUpdateReference() {
        return new Builder();
    }

    public static final class Builder {
        private QualityUpdateClassification classification;
        private OffsetDateTime releaseDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder classification(QualityUpdateClassification classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        public QualityUpdateReference build() {
            QualityUpdateReference _x = new QualityUpdateReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.qualityUpdateReference";
            _x.classification = classification;
            _x.releaseDateTime = releaseDateTime;
            return _x;
        }
    }

    private QualityUpdateReference _copy() {
        QualityUpdateReference _x = new QualityUpdateReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.classification = classification;
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QualityUpdateReference[");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
