package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "monitoringRules"})
@JsonInclude(Include.NON_NULL)
public class MonitoringSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("monitoringRules")
    protected List<MonitoringRule> monitoringRules;

    @JsonProperty("monitoringRules@nextLink")
    protected String monitoringRulesNextLink;

    protected MonitoringSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.monitoringSettings";
    }

    @Property(name="monitoringRules")
    @JsonIgnore
    public CollectionPage<MonitoringRule> getMonitoringRules() {
        return new CollectionPage<MonitoringRule>(contextPath, MonitoringRule.class, this.monitoringRules, Optional.ofNullable(monitoringRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="monitoringRules")
    @JsonIgnore
    public CollectionPage<MonitoringRule> getMonitoringRules(HttpRequestOptions options) {
        return new CollectionPage<MonitoringRule>(contextPath, MonitoringRule.class, this.monitoringRules, Optional.ofNullable(monitoringRulesNextLink), Collections.emptyList(), options);
    }

    public MonitoringSettings withUnmappedField(String name, Object value) {
        MonitoringSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MonitoringRule> monitoringRules;
        private String monitoringRulesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder monitoringRules(List<MonitoringRule> monitoringRules) {
            this.monitoringRules = monitoringRules;
            this.changedFields = changedFields.add("monitoringRules");
            return this;
        }

        public Builder monitoringRules(MonitoringRule... monitoringRules) {
            return monitoringRules(Arrays.asList(monitoringRules));
        }

        public Builder monitoringRulesNextLink(String monitoringRulesNextLink) {
            this.monitoringRulesNextLink = monitoringRulesNextLink;
            this.changedFields = changedFields.add("monitoringRules");
            return this;
        }

        public MonitoringSettings build() {
            MonitoringSettings _x = new MonitoringSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.monitoringSettings";
            _x.monitoringRules = monitoringRules;
            _x.monitoringRulesNextLink = monitoringRulesNextLink;
            return _x;
        }
    }

    private MonitoringSettings _copy() {
        MonitoringSettings _x = new MonitoringSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.monitoringRules = monitoringRules;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MonitoringSettings[");
        b.append("monitoringRules=");
        b.append(this.monitoringRules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
