package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.DeploymentStateValue;
import odata.msgraph.client.beta.windows.updates.enums.RequestedDeploymentStateValue;

@JsonPropertyOrder({
    "@odata.type", 
    "reasons", 
    "requestedValue", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class DeploymentState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("reasons")
    protected List<DeploymentStateReason> reasons;

    @JsonProperty("reasons@nextLink")
    protected String reasonsNextLink;

    @JsonProperty("requestedValue")
    protected RequestedDeploymentStateValue requestedValue;

    @JsonProperty("value")
    protected DeploymentStateValue value;

    protected DeploymentState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.deploymentState";
    }

    @Property(name="reasons")
    @JsonIgnore
    public CollectionPage<DeploymentStateReason> getReasons() {
        return new CollectionPage<DeploymentStateReason>(contextPath, DeploymentStateReason.class, this.reasons, Optional.ofNullable(reasonsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reasons")
    @JsonIgnore
    public CollectionPage<DeploymentStateReason> getReasons(HttpRequestOptions options) {
        return new CollectionPage<DeploymentStateReason>(contextPath, DeploymentStateReason.class, this.reasons, Optional.ofNullable(reasonsNextLink), Collections.emptyList(), options);
    }

    @Property(name="requestedValue")
    @JsonIgnore
    public Optional<RequestedDeploymentStateValue> getRequestedValue() {
        return Optional.ofNullable(requestedValue);
    }

    public DeploymentState withRequestedValue(RequestedDeploymentStateValue requestedValue) {
        DeploymentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deploymentState");
        _x.requestedValue = requestedValue;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<DeploymentStateValue> getValue() {
        return Optional.ofNullable(value);
    }

    public DeploymentState withValue(DeploymentStateValue value) {
        DeploymentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deploymentState");
        _x.value = value;
        return _x;
    }

    public DeploymentState withUnmappedField(String name, Object value) {
        DeploymentState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeploymentStateReason> reasons;
        private String reasonsNextLink;
        private RequestedDeploymentStateValue requestedValue;
        private DeploymentStateValue value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder reasons(List<DeploymentStateReason> reasons) {
            this.reasons = reasons;
            this.changedFields = changedFields.add("reasons");
            return this;
        }

        public Builder reasons(DeploymentStateReason... reasons) {
            return reasons(Arrays.asList(reasons));
        }

        public Builder reasonsNextLink(String reasonsNextLink) {
            this.reasonsNextLink = reasonsNextLink;
            this.changedFields = changedFields.add("reasons");
            return this;
        }

        public Builder requestedValue(RequestedDeploymentStateValue requestedValue) {
            this.requestedValue = requestedValue;
            this.changedFields = changedFields.add("requestedValue");
            return this;
        }

        public Builder value(DeploymentStateValue value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public DeploymentState build() {
            DeploymentState _x = new DeploymentState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.deploymentState";
            _x.reasons = reasons;
            _x.reasonsNextLink = reasonsNextLink;
            _x.requestedValue = requestedValue;
            _x.value = value;
            return _x;
        }
    }

    private DeploymentState _copy() {
        DeploymentState _x = new DeploymentState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.reasons = reasons;
        _x.requestedValue = requestedValue;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeploymentState[");
        b.append("reasons=");
        b.append(this.reasons);
        b.append(", ");
        b.append("requestedValue=");
        b.append(this.requestedValue);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
