package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "monitoring", 
    "rollout", 
    "safeguard"})
@JsonInclude(Include.NON_NULL)
public class DeploymentSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("monitoring")
    protected MonitoringSettings monitoring;

    @JsonProperty("rollout")
    protected RolloutSettings rollout;

    @JsonProperty("safeguard")
    protected SafeguardSettings safeguard;

    protected DeploymentSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.deploymentSettings";
    }

    @Property(name="monitoring")
    @JsonIgnore
    public Optional<MonitoringSettings> getMonitoring() {
        return Optional.ofNullable(monitoring);
    }

    public DeploymentSettings withMonitoring(MonitoringSettings monitoring) {
        DeploymentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deploymentSettings");
        _x.monitoring = monitoring;
        return _x;
    }

    @Property(name="rollout")
    @JsonIgnore
    public Optional<RolloutSettings> getRollout() {
        return Optional.ofNullable(rollout);
    }

    public DeploymentSettings withRollout(RolloutSettings rollout) {
        DeploymentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deploymentSettings");
        _x.rollout = rollout;
        return _x;
    }

    @Property(name="safeguard")
    @JsonIgnore
    public Optional<SafeguardSettings> getSafeguard() {
        return Optional.ofNullable(safeguard);
    }

    public DeploymentSettings withSafeguard(SafeguardSettings safeguard) {
        DeploymentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.deploymentSettings");
        _x.safeguard = safeguard;
        return _x;
    }

    public DeploymentSettings withUnmappedField(String name, Object value) {
        DeploymentSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MonitoringSettings monitoring;
        private RolloutSettings rollout;
        private SafeguardSettings safeguard;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder monitoring(MonitoringSettings monitoring) {
            this.monitoring = monitoring;
            this.changedFields = changedFields.add("monitoring");
            return this;
        }

        public Builder rollout(RolloutSettings rollout) {
            this.rollout = rollout;
            this.changedFields = changedFields.add("rollout");
            return this;
        }

        public Builder safeguard(SafeguardSettings safeguard) {
            this.safeguard = safeguard;
            this.changedFields = changedFields.add("safeguard");
            return this;
        }

        public DeploymentSettings build() {
            DeploymentSettings _x = new DeploymentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.deploymentSettings";
            _x.monitoring = monitoring;
            _x.rollout = rollout;
            _x.safeguard = safeguard;
            return _x;
        }
    }

    private DeploymentSettings _copy() {
        DeploymentSettings _x = new DeploymentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.monitoring = monitoring;
        _x.rollout = rollout;
        _x.safeguard = safeguard;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeploymentSettings[");
        b.append("monitoring=");
        b.append(this.monitoring);
        b.append(", ");
        b.append("rollout=");
        b.append(this.rollout);
        b.append(", ");
        b.append("safeguard=");
        b.append(this.safeguard);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
