package odata.msgraph.client.beta.termStore.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TermGroupScope implements Enum {

    @JsonProperty("global")
    GLOBAL("global", "0"),

    @JsonProperty("system")
    SYSTEM("system", "1"),

    @JsonProperty("siteCollection")
    SITE_COLLECTION("siteCollection", "2");

    private final String name;
    private final String value;

    private TermGroupScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
