package odata.msgraph.client.beta.termStore.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RelationType implements Enum {

    @JsonProperty("pin")
    PIN("pin", "0"),

    @JsonProperty("reuse")
    REUSE("reuse", "1");

    private final String name;
    private final String value;

    private RelationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
