package odata.msgraph.client.beta.termStore.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Store;
import odata.msgraph.client.beta.termStore.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.SetCollectionRequest;

@JsonIgnoreType
public class StoreRequest extends EntityRequest<Store> {

    public StoreRequest(ContextPath contextPath, Optional<Object> value) {
        super(Store.class, contextPath, value, false);
    }

    public GroupRequest groups(String id) {
        return new GroupRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest groups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("groups"), Optional.empty());
    }

    public SetRequest sets(String id) {
        return new SetRequest(contextPath.addSegment("sets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SetCollectionRequest sets() {
        return new SetCollectionRequest(
                        contextPath.addSegment("sets"), Optional.empty());
    }

}
