package odata.msgraph.client.beta.termStore.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Set;
import odata.msgraph.client.beta.termStore.entity.collection.request.RelationCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.TermCollectionRequest;

@JsonIgnoreType
public class SetRequest extends EntityRequest<Set> {

    public SetRequest(ContextPath contextPath, Optional<Object> value) {
        super(Set.class, contextPath, value, false);
    }

    public TermRequest children(String id) {
        return new TermRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest children() {
        return new TermCollectionRequest(
                        contextPath.addSegment("children"), Optional.empty());
    }

    public GroupRequest parentGroup() {
        return new GroupRequest(contextPath.addSegment("parentGroup"), Optional.empty());
    }

    public RelationRequest relations(String id) {
        return new RelationRequest(contextPath.addSegment("relations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RelationCollectionRequest relations() {
        return new RelationCollectionRequest(
                        contextPath.addSegment("relations"), Optional.empty());
    }

    public TermRequest terms(String id) {
        return new TermRequest(contextPath.addSegment("terms").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest terms() {
        return new TermCollectionRequest(
                        contextPath.addSegment("terms"), Optional.empty());
    }

}
