package odata.msgraph.client.beta.termStore.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Term;
import odata.msgraph.client.beta.termStore.entity.request.RelationRequest;
import odata.msgraph.client.beta.termStore.entity.request.TermRequest;

public class TermCollectionRequest extends CollectionPageEntityRequest<Term, TermRequest>{

    protected ContextPath contextPath;

    public TermCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Term.class, cp -> new TermRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TermRequest children(String id) {
        return new TermRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest children() {
        return new TermCollectionRequest(contextPath.addSegment("children"), Optional.empty());
    }

    public RelationRequest relations(String id) {
        return new RelationRequest(contextPath.addSegment("relations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RelationCollectionRequest relations() {
        return new RelationCollectionRequest(contextPath.addSegment("relations"), Optional.empty());
    }

}
