package odata.msgraph.client.beta.termStore.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.termStore.entity.request.SetRequest;
import odata.msgraph.client.beta.termStore.entity.request.TermRequest;
import odata.msgraph.client.beta.termStore.enums.RelationType;

@JsonPropertyOrder({
    "@odata.type", 
    "relationship"})
@JsonInclude(Include.NON_NULL)
public class Relation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.relation";
    }

    @JsonProperty("relationship")
    protected RelationType relationship;

    protected Relation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRelation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private RelationType relationship;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder relationship(RelationType relationship) {
            this.relationship = relationship;
            this.changedFields = changedFields.add("relationship");
            return this;
        }

        public Relation build() {
            Relation _x = new Relation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.relation";
            _x.id = id;
            _x.relationship = relationship;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="relationship")
    @JsonIgnore
    public Optional<RelationType> getRelationship() {
        return Optional.ofNullable(relationship);
    }

    public Relation withRelationship(RelationType relationship) {
        Relation _x = _copy();
        _x.changedFields = changedFields.add("relationship");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.relation");
        _x.relationship = relationship;
        return _x;
    }

    public Relation withUnmappedField(String name, Object value) {
        Relation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="fromTerm")
    @JsonIgnore
    public TermRequest getFromTerm() {
        return new TermRequest(contextPath.addSegment("fromTerm"), RequestHelper.getValue(unmappedFields, "fromTerm"));
    }

    @NavigationProperty(name="set")
    @JsonIgnore
    public SetRequest getSet() {
        return new SetRequest(contextPath.addSegment("set"), RequestHelper.getValue(unmappedFields, "set"));
    }

    @NavigationProperty(name="toTerm")
    @JsonIgnore
    public TermRequest getToTerm() {
        return new TermRequest(contextPath.addSegment("toTerm"), RequestHelper.getValue(unmappedFields, "toTerm"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Relation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Relation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Relation _copy() {
        Relation _x = new Relation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.relationship = relationship;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Relation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("relationship=");
        b.append(this.relationship);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
