package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WorkloadActionCategory implements Enum {

    @JsonProperty("automated")
    AUTOMATED("automated", "0"),

    @JsonProperty("manual")
    MANUAL("manual", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private WorkloadActionCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
