package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TenantOnboardingStatus implements Enum {

    @JsonProperty("ineligible")
    INELIGIBLE("ineligible", "0"),

    @JsonProperty("inProcess")
    IN_PROCESS("inProcess", "1"),

    @JsonProperty("active")
    ACTIVE("active", "2"),

    @JsonProperty("inactive")
    INACTIVE("inactive", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private TenantOnboardingStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
