package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TenantOnboardingEligibilityReason implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("contractType")
    CONTRACT_TYPE("contractType", "1"),

    @JsonProperty("delegatedAdminPrivileges")
    DELEGATED_ADMIN_PRIVILEGES("delegatedAdminPrivileges", "2"),

    @JsonProperty("usersCount")
    USERS_COUNT("usersCount", "3"),

    @JsonProperty("license")
    LICENSE("license", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private TenantOnboardingEligibilityReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
