package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementProvider implements Enum {

    @JsonProperty("microsoft")
    MICROSOFT("microsoft", "0"),

    @JsonProperty("community")
    COMMUNITY("community", "1"),

    @JsonProperty("indirectProvider")
    INDIRECT_PROVIDER("indirectProvider", "2"),

    @JsonProperty("self")
    SELF("self", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ManagementProvider(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
