package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementActionStatus implements Enum {

    @JsonProperty("toAddress")
    TO_ADDRESS("toAddress", "0"),

    @JsonProperty("completed")
    COMPLETED("completed", "5"),

    @JsonProperty("error")
    ERROR("error", "10"),

    @JsonProperty("timeOut")
    TIME_OUT("timeOut", "15"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "20"),

    @JsonProperty("planned")
    PLANNED("planned", "25"),

    @JsonProperty("resolvedBy3rdParty")
    RESOLVED_BY3RD_PARTY("resolvedBy3rdParty", "30"),

    @JsonProperty("resolvedThroughAlternateMitigation")
    RESOLVED_THROUGH_ALTERNATE_MITIGATION("resolvedThroughAlternateMitigation", "35"),

    @JsonProperty("riskAccepted")
    RISK_ACCEPTED("riskAccepted", "40"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "45");

    private final String name;
    private final String value;

    private ManagementActionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
