package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.TenantTag;

@JsonIgnoreType
public class TenantTagRequest extends EntityRequest<TenantTag> {

    public TenantTagRequest(ContextPath contextPath, Optional<Object> value) {
        super(TenantTag.class, contextPath, value, false);
    }

    @Action(name = "assignTag")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TenantTag> assignTag(List<String> tenantIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantIds", "Collection(Edm.String)", Checks.checkIsAscii(tenantIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TenantTag>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.assignTag"), TenantTag.class, _parameters);
    }

    @Action(name = "unassignTag")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TenantTag> unassignTag(List<String> tenantIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantIds", "Collection(Edm.String)", Checks.checkIsAscii(tenantIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TenantTag>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.unassignTag"), TenantTag.class, _parameters);
    }

}
