package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateStep;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepVersionCollectionRequest;

@JsonIgnoreType
public class ManagementTemplateStepRequest extends EntityRequest<ManagementTemplateStep> {

    public ManagementTemplateStepRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementTemplateStep.class, contextPath, value, false);
    }

    public ManagementTemplateStepVersionRequest acceptedVersion() {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("acceptedVersion"), Optional.empty());
    }

    public ManagementTemplateRequest managementTemplate() {
        return new ManagementTemplateRequest(contextPath.addSegment("managementTemplate"), Optional.empty());
    }

    public ManagementTemplateStepVersionRequest versions(String id) {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepVersionCollectionRequest versions() {
        return new ManagementTemplateStepVersionCollectionRequest(
                        contextPath.addSegment("versions"), Optional.empty());
    }

}
