package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.complex.ManagementActionDeploymentStatus;
import odata.msgraph.client.beta.managed.tenants.entity.ManagementAction;

@JsonIgnoreType
public class ManagementActionRequest extends EntityRequest<ManagementAction> {

    public ManagementActionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementAction.class, contextPath, value, false);
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus> apply(String tenantId, String tenantGroupId, String managementTemplateId, Boolean includeAllUsers, List<String> includeGroups, List<String> excludeGroups) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("tenantGroupId", "Edm.String", Checks.checkIsAscii(tenantGroupId))
            .put("managementTemplateId", "Edm.String", Checks.checkIsAscii(managementTemplateId))
            .put("includeAllUsers", "Edm.Boolean", includeAllUsers)
            .put("includeGroups", "Collection(Edm.String)", Checks.checkIsAscii(includeGroups))
            .put("excludeGroups", "Collection(Edm.String)", Checks.checkIsAscii(excludeGroups))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.apply"), ManagementActionDeploymentStatus.class, _parameters);
    }

}
