package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagedTenant;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.AggregatedPolicyComplianceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcConnectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcDeviceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CloudPcOverviewCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ConditionalAccessPolicyCoverageCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.CredentialUserRegistrationsSummaryCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagedDeviceComplianceCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagedDeviceComplianceTrendCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementActionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementActionTenantDeploymentStatusCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementIntentCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepVersionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantCustomizedInformationCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantDetailedInformationCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantGroupCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.TenantTagCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.WindowsDeviceMalwareStateCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.WindowsProtectionStateCollectionRequest;

@JsonIgnoreType
public class ManagedTenantRequest extends EntityRequest<ManagedTenant> {

    public ManagedTenantRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagedTenant.class, contextPath, value, false);
    }

    public AggregatedPolicyComplianceRequest aggregatedPolicyCompliances(String id) {
        return new AggregatedPolicyComplianceRequest(contextPath.addSegment("aggregatedPolicyCompliances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AggregatedPolicyComplianceCollectionRequest aggregatedPolicyCompliances() {
        return new AggregatedPolicyComplianceCollectionRequest(
                        contextPath.addSegment("aggregatedPolicyCompliances"), Optional.empty());
    }

    public AuditEventRequest auditEvents(String id) {
        return new AuditEventRequest(contextPath.addSegment("auditEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuditEventCollectionRequest auditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.empty());
    }

    public CloudPcConnectionRequest cloudPcConnections(String id) {
        return new CloudPcConnectionRequest(contextPath.addSegment("cloudPcConnections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcConnectionCollectionRequest cloudPcConnections() {
        return new CloudPcConnectionCollectionRequest(
                        contextPath.addSegment("cloudPcConnections"), Optional.empty());
    }

    public CloudPcDeviceRequest cloudPcDevices(String id) {
        return new CloudPcDeviceRequest(contextPath.addSegment("cloudPcDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcDeviceCollectionRequest cloudPcDevices() {
        return new CloudPcDeviceCollectionRequest(
                        contextPath.addSegment("cloudPcDevices"), Optional.empty());
    }

    public CloudPcOverviewRequest cloudPcsOverview(String tenantId) {
        return new CloudPcOverviewRequest(contextPath.addSegment("cloudPcsOverview").addKeys(new NameValue(tenantId, String.class)), Optional.empty());
    }

    public CloudPcOverviewCollectionRequest cloudPcsOverview() {
        return new CloudPcOverviewCollectionRequest(
                        contextPath.addSegment("cloudPcsOverview"), Optional.empty());
    }

    public ConditionalAccessPolicyCoverageRequest conditionalAccessPolicyCoverages(String id) {
        return new ConditionalAccessPolicyCoverageRequest(contextPath.addSegment("conditionalAccessPolicyCoverages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConditionalAccessPolicyCoverageCollectionRequest conditionalAccessPolicyCoverages() {
        return new ConditionalAccessPolicyCoverageCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicyCoverages"), Optional.empty());
    }

    public CredentialUserRegistrationsSummaryRequest credentialUserRegistrationsSummaries(String id) {
        return new CredentialUserRegistrationsSummaryRequest(contextPath.addSegment("credentialUserRegistrationsSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CredentialUserRegistrationsSummaryCollectionRequest credentialUserRegistrationsSummaries() {
        return new CredentialUserRegistrationsSummaryCollectionRequest(
                        contextPath.addSegment("credentialUserRegistrationsSummaries"), Optional.empty());
    }

    public DeviceCompliancePolicySettingStateSummaryRequest deviceCompliancePolicySettingStateSummaries(String id) {
        return new DeviceCompliancePolicySettingStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicySettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicySettingStateSummaryCollectionRequest deviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"), Optional.empty());
    }

    public ManagedDeviceComplianceRequest managedDeviceCompliances(String id) {
        return new ManagedDeviceComplianceRequest(contextPath.addSegment("managedDeviceCompliances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceComplianceCollectionRequest managedDeviceCompliances() {
        return new ManagedDeviceComplianceCollectionRequest(
                        contextPath.addSegment("managedDeviceCompliances"), Optional.empty());
    }

    public ManagedDeviceComplianceTrendRequest managedDeviceComplianceTrends(String id) {
        return new ManagedDeviceComplianceTrendRequest(contextPath.addSegment("managedDeviceComplianceTrends").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceComplianceTrendCollectionRequest managedDeviceComplianceTrends() {
        return new ManagedDeviceComplianceTrendCollectionRequest(
                        contextPath.addSegment("managedDeviceComplianceTrends"), Optional.empty());
    }

    public ManagementActionRequest managementActions(String id) {
        return new ManagementActionRequest(contextPath.addSegment("managementActions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementActionCollectionRequest managementActions() {
        return new ManagementActionCollectionRequest(
                        contextPath.addSegment("managementActions"), Optional.empty());
    }

    public ManagementActionTenantDeploymentStatusRequest managementActionTenantDeploymentStatuses(String id) {
        return new ManagementActionTenantDeploymentStatusRequest(contextPath.addSegment("managementActionTenantDeploymentStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementActionTenantDeploymentStatusCollectionRequest managementActionTenantDeploymentStatuses() {
        return new ManagementActionTenantDeploymentStatusCollectionRequest(
                        contextPath.addSegment("managementActionTenantDeploymentStatuses"), Optional.empty());
    }

    public ManagementIntentRequest managementIntents(String id) {
        return new ManagementIntentRequest(contextPath.addSegment("managementIntents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementIntentCollectionRequest managementIntents() {
        return new ManagementIntentCollectionRequest(
                        contextPath.addSegment("managementIntents"), Optional.empty());
    }

    public ManagementTemplateCollectionRequest managementTemplateCollections(String id) {
        return new ManagementTemplateCollectionRequest(contextPath.addSegment("managementTemplateCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateCollectionCollectionRequest managementTemplateCollections() {
        return new ManagementTemplateCollectionCollectionRequest(
                        contextPath.addSegment("managementTemplateCollections"), Optional.empty());
    }

    public ManagementTemplateRequest managementTemplates(String id) {
        return new ManagementTemplateRequest(contextPath.addSegment("managementTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest managementTemplates() {
        return new odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest(
                        contextPath.addSegment("managementTemplates"), Optional.empty());
    }

    public ManagementTemplateStepRequest managementTemplateSteps(String id) {
        return new ManagementTemplateStepRequest(contextPath.addSegment("managementTemplateSteps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepCollectionRequest managementTemplateSteps() {
        return new ManagementTemplateStepCollectionRequest(
                        contextPath.addSegment("managementTemplateSteps"), Optional.empty());
    }

    public ManagementTemplateStepVersionRequest managementTemplateStepVersions(String id) {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("managementTemplateStepVersions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepVersionCollectionRequest managementTemplateStepVersions() {
        return new ManagementTemplateStepVersionCollectionRequest(
                        contextPath.addSegment("managementTemplateStepVersions"), Optional.empty());
    }

    public TenantGroupRequest tenantGroups(String id) {
        return new TenantGroupRequest(contextPath.addSegment("tenantGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantGroupCollectionRequest tenantGroups() {
        return new TenantGroupCollectionRequest(
                        contextPath.addSegment("tenantGroups"), Optional.empty());
    }

    public TenantRequest tenants(String id) {
        return new TenantRequest(contextPath.addSegment("tenants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantCollectionRequest tenants() {
        return new TenantCollectionRequest(
                        contextPath.addSegment("tenants"), Optional.empty());
    }

    public TenantCustomizedInformationRequest tenantsCustomizedInformation(String id) {
        return new TenantCustomizedInformationRequest(contextPath.addSegment("tenantsCustomizedInformation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantCustomizedInformationCollectionRequest tenantsCustomizedInformation() {
        return new TenantCustomizedInformationCollectionRequest(
                        contextPath.addSegment("tenantsCustomizedInformation"), Optional.empty());
    }

    public TenantDetailedInformationRequest tenantsDetailedInformation(String id) {
        return new TenantDetailedInformationRequest(contextPath.addSegment("tenantsDetailedInformation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantDetailedInformationCollectionRequest tenantsDetailedInformation() {
        return new TenantDetailedInformationCollectionRequest(
                        contextPath.addSegment("tenantsDetailedInformation"), Optional.empty());
    }

    public TenantTagRequest tenantTags(String id) {
        return new TenantTagRequest(contextPath.addSegment("tenantTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantTagCollectionRequest tenantTags() {
        return new TenantTagCollectionRequest(
                        contextPath.addSegment("tenantTags"), Optional.empty());
    }

    public WindowsDeviceMalwareStateRequest windowsDeviceMalwareStates(String id) {
        return new WindowsDeviceMalwareStateRequest(contextPath.addSegment("windowsDeviceMalwareStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDeviceMalwareStateCollectionRequest windowsDeviceMalwareStates() {
        return new WindowsDeviceMalwareStateCollectionRequest(
                        contextPath.addSegment("windowsDeviceMalwareStates"), Optional.empty());
    }

    public WindowsProtectionStateRequest windowsProtectionStates(String id) {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsProtectionStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsProtectionStateCollectionRequest windowsProtectionStates() {
        return new WindowsProtectionStateCollectionRequest(
                        contextPath.addSegment("windowsProtectionStates"), Optional.empty());
    }

}
