package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.TenantGroup;
import odata.msgraph.client.beta.managed.tenants.entity.request.TenantGroupRequest;

public class TenantGroupCollectionRequest extends CollectionPageEntityRequest<TenantGroup, TenantGroupRequest>{

    protected ContextPath contextPath;

    public TenantGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TenantGroup.class, cp -> new TenantGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "tenantSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TenantGroup> tenantSearch(String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.tenantSearch"), TenantGroup.class, _parameters);
    }

}
