package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateStep;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepVersionRequest;

public class ManagementTemplateStepCollectionRequest extends CollectionPageEntityRequest<ManagementTemplateStep, ManagementTemplateStepRequest>{

    protected ContextPath contextPath;

    public ManagementTemplateStepCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementTemplateStep.class, cp -> new ManagementTemplateStepRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagementTemplateStepVersionRequest versions(String id) {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepVersionCollectionRequest versions() {
        return new ManagementTemplateStepVersionCollectionRequest(contextPath.addSegment("versions"), Optional.empty());
    }

}
