package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.complex.ManagementActionDeploymentStatus;
import odata.msgraph.client.beta.managed.tenants.entity.ManagementActionTenantDeploymentStatus;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementActionTenantDeploymentStatusRequest;

public class ManagementActionTenantDeploymentStatusCollectionRequest extends CollectionPageEntityRequest<ManagementActionTenantDeploymentStatus, ManagementActionTenantDeploymentStatusRequest>{

    protected ContextPath contextPath;

    public ManagementActionTenantDeploymentStatusCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementActionTenantDeploymentStatus.class, cp -> new ManagementActionTenantDeploymentStatusRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "changeDeploymentStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus> changeDeploymentStatus(String tenantGroupId, String tenantId, String managementActionId, String managementTemplateId, Integer managementTemplateVersion, String status) {
        Preconditions.checkNotNull(managementTemplateVersion, "managementTemplateVersion cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantGroupId", "Edm.String", Checks.checkIsAscii(tenantGroupId))
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("managementActionId", "Edm.String", Checks.checkIsAscii(managementActionId))
            .put("managementTemplateId", "Edm.String", Checks.checkIsAscii(managementTemplateId))
            .put("managementTemplateVersion", "Edm.Int32", managementTemplateVersion)
            .put("status", "Edm.String", Checks.checkIsAscii(status))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.changeDeploymentStatus"), ManagementActionDeploymentStatus.class, _parameters);
    }

}
