package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "antiMalwareVersion", 
    "attentionRequired", 
    "deviceDeleted", 
    "devicePropertyRefreshDateTime", 
    "engineVersion", 
    "fullScanOverdue", 
    "fullScanRequired", 
    "lastFullScanDateTime", 
    "lastFullScanSignatureVersion", 
    "lastQuickScanDateTime", 
    "lastQuickScanSignatureVersion", 
    "lastRefreshedDateTime", 
    "lastReportedDateTime", 
    "malwareProtectionEnabled", 
    "managedDeviceHealthState", 
    "managedDeviceId", 
    "managedDeviceName", 
    "networkInspectionSystemEnabled", 
    "quickScanOverdue", 
    "realTimeProtectionEnabled", 
    "rebootRequired", 
    "signatureUpdateOverdue", 
    "signatureVersion", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class WindowsProtectionState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.windowsProtectionState";
    }

    @JsonProperty("antiMalwareVersion")
    protected String antiMalwareVersion;

    @JsonProperty("attentionRequired")
    protected Boolean attentionRequired;

    @JsonProperty("deviceDeleted")
    protected Boolean deviceDeleted;

    @JsonProperty("devicePropertyRefreshDateTime")
    protected OffsetDateTime devicePropertyRefreshDateTime;

    @JsonProperty("engineVersion")
    protected String engineVersion;

    @JsonProperty("fullScanOverdue")
    protected Boolean fullScanOverdue;

    @JsonProperty("fullScanRequired")
    protected Boolean fullScanRequired;

    @JsonProperty("lastFullScanDateTime")
    protected OffsetDateTime lastFullScanDateTime;

    @JsonProperty("lastFullScanSignatureVersion")
    protected String lastFullScanSignatureVersion;

    @JsonProperty("lastQuickScanDateTime")
    protected OffsetDateTime lastQuickScanDateTime;

    @JsonProperty("lastQuickScanSignatureVersion")
    protected String lastQuickScanSignatureVersion;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("malwareProtectionEnabled")
    protected Boolean malwareProtectionEnabled;

    @JsonProperty("managedDeviceHealthState")
    protected String managedDeviceHealthState;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("networkInspectionSystemEnabled")
    protected Boolean networkInspectionSystemEnabled;

    @JsonProperty("quickScanOverdue")
    protected Boolean quickScanOverdue;

    @JsonProperty("realTimeProtectionEnabled")
    protected Boolean realTimeProtectionEnabled;

    @JsonProperty("rebootRequired")
    protected Boolean rebootRequired;

    @JsonProperty("signatureUpdateOverdue")
    protected Boolean signatureUpdateOverdue;

    @JsonProperty("signatureVersion")
    protected String signatureVersion;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected WindowsProtectionState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsProtectionState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String antiMalwareVersion;
        private Boolean attentionRequired;
        private Boolean deviceDeleted;
        private OffsetDateTime devicePropertyRefreshDateTime;
        private String engineVersion;
        private Boolean fullScanOverdue;
        private Boolean fullScanRequired;
        private OffsetDateTime lastFullScanDateTime;
        private String lastFullScanSignatureVersion;
        private OffsetDateTime lastQuickScanDateTime;
        private String lastQuickScanSignatureVersion;
        private OffsetDateTime lastRefreshedDateTime;
        private OffsetDateTime lastReportedDateTime;
        private Boolean malwareProtectionEnabled;
        private String managedDeviceHealthState;
        private String managedDeviceId;
        private String managedDeviceName;
        private Boolean networkInspectionSystemEnabled;
        private Boolean quickScanOverdue;
        private Boolean realTimeProtectionEnabled;
        private Boolean rebootRequired;
        private Boolean signatureUpdateOverdue;
        private String signatureVersion;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder antiMalwareVersion(String antiMalwareVersion) {
            this.antiMalwareVersion = antiMalwareVersion;
            this.changedFields = changedFields.add("antiMalwareVersion");
            return this;
        }

        public Builder attentionRequired(Boolean attentionRequired) {
            this.attentionRequired = attentionRequired;
            this.changedFields = changedFields.add("attentionRequired");
            return this;
        }

        public Builder deviceDeleted(Boolean deviceDeleted) {
            this.deviceDeleted = deviceDeleted;
            this.changedFields = changedFields.add("deviceDeleted");
            return this;
        }

        public Builder devicePropertyRefreshDateTime(OffsetDateTime devicePropertyRefreshDateTime) {
            this.devicePropertyRefreshDateTime = devicePropertyRefreshDateTime;
            this.changedFields = changedFields.add("devicePropertyRefreshDateTime");
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            this.changedFields = changedFields.add("engineVersion");
            return this;
        }

        public Builder fullScanOverdue(Boolean fullScanOverdue) {
            this.fullScanOverdue = fullScanOverdue;
            this.changedFields = changedFields.add("fullScanOverdue");
            return this;
        }

        public Builder fullScanRequired(Boolean fullScanRequired) {
            this.fullScanRequired = fullScanRequired;
            this.changedFields = changedFields.add("fullScanRequired");
            return this;
        }

        public Builder lastFullScanDateTime(OffsetDateTime lastFullScanDateTime) {
            this.lastFullScanDateTime = lastFullScanDateTime;
            this.changedFields = changedFields.add("lastFullScanDateTime");
            return this;
        }

        public Builder lastFullScanSignatureVersion(String lastFullScanSignatureVersion) {
            this.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
            this.changedFields = changedFields.add("lastFullScanSignatureVersion");
            return this;
        }

        public Builder lastQuickScanDateTime(OffsetDateTime lastQuickScanDateTime) {
            this.lastQuickScanDateTime = lastQuickScanDateTime;
            this.changedFields = changedFields.add("lastQuickScanDateTime");
            return this;
        }

        public Builder lastQuickScanSignatureVersion(String lastQuickScanSignatureVersion) {
            this.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
            this.changedFields = changedFields.add("lastQuickScanSignatureVersion");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        public Builder malwareProtectionEnabled(Boolean malwareProtectionEnabled) {
            this.malwareProtectionEnabled = malwareProtectionEnabled;
            this.changedFields = changedFields.add("malwareProtectionEnabled");
            return this;
        }

        public Builder managedDeviceHealthState(String managedDeviceHealthState) {
            this.managedDeviceHealthState = managedDeviceHealthState;
            this.changedFields = changedFields.add("managedDeviceHealthState");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder networkInspectionSystemEnabled(Boolean networkInspectionSystemEnabled) {
            this.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
            this.changedFields = changedFields.add("networkInspectionSystemEnabled");
            return this;
        }

        public Builder quickScanOverdue(Boolean quickScanOverdue) {
            this.quickScanOverdue = quickScanOverdue;
            this.changedFields = changedFields.add("quickScanOverdue");
            return this;
        }

        public Builder realTimeProtectionEnabled(Boolean realTimeProtectionEnabled) {
            this.realTimeProtectionEnabled = realTimeProtectionEnabled;
            this.changedFields = changedFields.add("realTimeProtectionEnabled");
            return this;
        }

        public Builder rebootRequired(Boolean rebootRequired) {
            this.rebootRequired = rebootRequired;
            this.changedFields = changedFields.add("rebootRequired");
            return this;
        }

        public Builder signatureUpdateOverdue(Boolean signatureUpdateOverdue) {
            this.signatureUpdateOverdue = signatureUpdateOverdue;
            this.changedFields = changedFields.add("signatureUpdateOverdue");
            return this;
        }

        public Builder signatureVersion(String signatureVersion) {
            this.signatureVersion = signatureVersion;
            this.changedFields = changedFields.add("signatureVersion");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public WindowsProtectionState build() {
            WindowsProtectionState _x = new WindowsProtectionState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.windowsProtectionState";
            _x.id = id;
            _x.antiMalwareVersion = antiMalwareVersion;
            _x.attentionRequired = attentionRequired;
            _x.deviceDeleted = deviceDeleted;
            _x.devicePropertyRefreshDateTime = devicePropertyRefreshDateTime;
            _x.engineVersion = engineVersion;
            _x.fullScanOverdue = fullScanOverdue;
            _x.fullScanRequired = fullScanRequired;
            _x.lastFullScanDateTime = lastFullScanDateTime;
            _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
            _x.lastQuickScanDateTime = lastQuickScanDateTime;
            _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.malwareProtectionEnabled = malwareProtectionEnabled;
            _x.managedDeviceHealthState = managedDeviceHealthState;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
            _x.quickScanOverdue = quickScanOverdue;
            _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
            _x.rebootRequired = rebootRequired;
            _x.signatureUpdateOverdue = signatureUpdateOverdue;
            _x.signatureVersion = signatureVersion;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="antiMalwareVersion")
    @JsonIgnore
    public Optional<String> getAntiMalwareVersion() {
        return Optional.ofNullable(antiMalwareVersion);
    }

    public WindowsProtectionState withAntiMalwareVersion(String antiMalwareVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("antiMalwareVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.antiMalwareVersion = antiMalwareVersion;
        return _x;
    }

    @Property(name="attentionRequired")
    @JsonIgnore
    public Optional<Boolean> getAttentionRequired() {
        return Optional.ofNullable(attentionRequired);
    }

    public WindowsProtectionState withAttentionRequired(Boolean attentionRequired) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("attentionRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.attentionRequired = attentionRequired;
        return _x;
    }

    @Property(name="deviceDeleted")
    @JsonIgnore
    public Optional<Boolean> getDeviceDeleted() {
        return Optional.ofNullable(deviceDeleted);
    }

    public WindowsProtectionState withDeviceDeleted(Boolean deviceDeleted) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("deviceDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.deviceDeleted = deviceDeleted;
        return _x;
    }

    @Property(name="devicePropertyRefreshDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDevicePropertyRefreshDateTime() {
        return Optional.ofNullable(devicePropertyRefreshDateTime);
    }

    public WindowsProtectionState withDevicePropertyRefreshDateTime(OffsetDateTime devicePropertyRefreshDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("devicePropertyRefreshDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.devicePropertyRefreshDateTime = devicePropertyRefreshDateTime;
        return _x;
    }

    @Property(name="engineVersion")
    @JsonIgnore
    public Optional<String> getEngineVersion() {
        return Optional.ofNullable(engineVersion);
    }

    public WindowsProtectionState withEngineVersion(String engineVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("engineVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.engineVersion = engineVersion;
        return _x;
    }

    @Property(name="fullScanOverdue")
    @JsonIgnore
    public Optional<Boolean> getFullScanOverdue() {
        return Optional.ofNullable(fullScanOverdue);
    }

    public WindowsProtectionState withFullScanOverdue(Boolean fullScanOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("fullScanOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.fullScanOverdue = fullScanOverdue;
        return _x;
    }

    @Property(name="fullScanRequired")
    @JsonIgnore
    public Optional<Boolean> getFullScanRequired() {
        return Optional.ofNullable(fullScanRequired);
    }

    public WindowsProtectionState withFullScanRequired(Boolean fullScanRequired) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("fullScanRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.fullScanRequired = fullScanRequired;
        return _x;
    }

    @Property(name="lastFullScanDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastFullScanDateTime() {
        return Optional.ofNullable(lastFullScanDateTime);
    }

    public WindowsProtectionState withLastFullScanDateTime(OffsetDateTime lastFullScanDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastFullScanDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastFullScanDateTime = lastFullScanDateTime;
        return _x;
    }

    @Property(name="lastFullScanSignatureVersion")
    @JsonIgnore
    public Optional<String> getLastFullScanSignatureVersion() {
        return Optional.ofNullable(lastFullScanSignatureVersion);
    }

    public WindowsProtectionState withLastFullScanSignatureVersion(String lastFullScanSignatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastFullScanSignatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
        return _x;
    }

    @Property(name="lastQuickScanDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastQuickScanDateTime() {
        return Optional.ofNullable(lastQuickScanDateTime);
    }

    public WindowsProtectionState withLastQuickScanDateTime(OffsetDateTime lastQuickScanDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastQuickScanDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastQuickScanDateTime = lastQuickScanDateTime;
        return _x;
    }

    @Property(name="lastQuickScanSignatureVersion")
    @JsonIgnore
    public Optional<String> getLastQuickScanSignatureVersion() {
        return Optional.ofNullable(lastQuickScanSignatureVersion);
    }

    public WindowsProtectionState withLastQuickScanSignatureVersion(String lastQuickScanSignatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastQuickScanSignatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public WindowsProtectionState withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    public WindowsProtectionState withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    @Property(name="malwareProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getMalwareProtectionEnabled() {
        return Optional.ofNullable(malwareProtectionEnabled);
    }

    public WindowsProtectionState withMalwareProtectionEnabled(Boolean malwareProtectionEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("malwareProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.malwareProtectionEnabled = malwareProtectionEnabled;
        return _x;
    }

    @Property(name="managedDeviceHealthState")
    @JsonIgnore
    public Optional<String> getManagedDeviceHealthState() {
        return Optional.ofNullable(managedDeviceHealthState);
    }

    public WindowsProtectionState withManagedDeviceHealthState(String managedDeviceHealthState) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceHealthState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.managedDeviceHealthState = managedDeviceHealthState;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public WindowsProtectionState withManagedDeviceId(String managedDeviceId) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    public WindowsProtectionState withManagedDeviceName(String managedDeviceName) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    @Property(name="networkInspectionSystemEnabled")
    @JsonIgnore
    public Optional<Boolean> getNetworkInspectionSystemEnabled() {
        return Optional.ofNullable(networkInspectionSystemEnabled);
    }

    public WindowsProtectionState withNetworkInspectionSystemEnabled(Boolean networkInspectionSystemEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("networkInspectionSystemEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
        return _x;
    }

    @Property(name="quickScanOverdue")
    @JsonIgnore
    public Optional<Boolean> getQuickScanOverdue() {
        return Optional.ofNullable(quickScanOverdue);
    }

    public WindowsProtectionState withQuickScanOverdue(Boolean quickScanOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("quickScanOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.quickScanOverdue = quickScanOverdue;
        return _x;
    }

    @Property(name="realTimeProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getRealTimeProtectionEnabled() {
        return Optional.ofNullable(realTimeProtectionEnabled);
    }

    public WindowsProtectionState withRealTimeProtectionEnabled(Boolean realTimeProtectionEnabled) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("realTimeProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
        return _x;
    }

    @Property(name="rebootRequired")
    @JsonIgnore
    public Optional<Boolean> getRebootRequired() {
        return Optional.ofNullable(rebootRequired);
    }

    public WindowsProtectionState withRebootRequired(Boolean rebootRequired) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("rebootRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.rebootRequired = rebootRequired;
        return _x;
    }

    @Property(name="signatureUpdateOverdue")
    @JsonIgnore
    public Optional<Boolean> getSignatureUpdateOverdue() {
        return Optional.ofNullable(signatureUpdateOverdue);
    }

    public WindowsProtectionState withSignatureUpdateOverdue(Boolean signatureUpdateOverdue) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("signatureUpdateOverdue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.signatureUpdateOverdue = signatureUpdateOverdue;
        return _x;
    }

    @Property(name="signatureVersion")
    @JsonIgnore
    public Optional<String> getSignatureVersion() {
        return Optional.ofNullable(signatureVersion);
    }

    public WindowsProtectionState withSignatureVersion(String signatureVersion) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("signatureVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.signatureVersion = signatureVersion;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public WindowsProtectionState withTenantDisplayName(String tenantDisplayName) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public WindowsProtectionState withTenantId(String tenantId) {
        WindowsProtectionState _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsProtectionState");
        _x.tenantId = tenantId;
        return _x;
    }

    public WindowsProtectionState withUnmappedField(String name, Object value) {
        WindowsProtectionState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsProtectionState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsProtectionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsProtectionState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsProtectionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsProtectionState _copy() {
        WindowsProtectionState _x = new WindowsProtectionState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.antiMalwareVersion = antiMalwareVersion;
        _x.attentionRequired = attentionRequired;
        _x.deviceDeleted = deviceDeleted;
        _x.devicePropertyRefreshDateTime = devicePropertyRefreshDateTime;
        _x.engineVersion = engineVersion;
        _x.fullScanOverdue = fullScanOverdue;
        _x.fullScanRequired = fullScanRequired;
        _x.lastFullScanDateTime = lastFullScanDateTime;
        _x.lastFullScanSignatureVersion = lastFullScanSignatureVersion;
        _x.lastQuickScanDateTime = lastQuickScanDateTime;
        _x.lastQuickScanSignatureVersion = lastQuickScanSignatureVersion;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.malwareProtectionEnabled = malwareProtectionEnabled;
        _x.managedDeviceHealthState = managedDeviceHealthState;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.networkInspectionSystemEnabled = networkInspectionSystemEnabled;
        _x.quickScanOverdue = quickScanOverdue;
        _x.realTimeProtectionEnabled = realTimeProtectionEnabled;
        _x.rebootRequired = rebootRequired;
        _x.signatureUpdateOverdue = signatureUpdateOverdue;
        _x.signatureVersion = signatureVersion;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsProtectionState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("antiMalwareVersion=");
        b.append(this.antiMalwareVersion);
        b.append(", ");
        b.append("attentionRequired=");
        b.append(this.attentionRequired);
        b.append(", ");
        b.append("deviceDeleted=");
        b.append(this.deviceDeleted);
        b.append(", ");
        b.append("devicePropertyRefreshDateTime=");
        b.append(this.devicePropertyRefreshDateTime);
        b.append(", ");
        b.append("engineVersion=");
        b.append(this.engineVersion);
        b.append(", ");
        b.append("fullScanOverdue=");
        b.append(this.fullScanOverdue);
        b.append(", ");
        b.append("fullScanRequired=");
        b.append(this.fullScanRequired);
        b.append(", ");
        b.append("lastFullScanDateTime=");
        b.append(this.lastFullScanDateTime);
        b.append(", ");
        b.append("lastFullScanSignatureVersion=");
        b.append(this.lastFullScanSignatureVersion);
        b.append(", ");
        b.append("lastQuickScanDateTime=");
        b.append(this.lastQuickScanDateTime);
        b.append(", ");
        b.append("lastQuickScanSignatureVersion=");
        b.append(this.lastQuickScanSignatureVersion);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("malwareProtectionEnabled=");
        b.append(this.malwareProtectionEnabled);
        b.append(", ");
        b.append("managedDeviceHealthState=");
        b.append(this.managedDeviceHealthState);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("networkInspectionSystemEnabled=");
        b.append(this.networkInspectionSystemEnabled);
        b.append(", ");
        b.append("quickScanOverdue=");
        b.append(this.quickScanOverdue);
        b.append(", ");
        b.append("realTimeProtectionEnabled=");
        b.append(this.realTimeProtectionEnabled);
        b.append(", ");
        b.append("rebootRequired=");
        b.append(this.rebootRequired);
        b.append(", ");
        b.append("signatureUpdateOverdue=");
        b.append(this.signatureUpdateOverdue);
        b.append(", ");
        b.append("signatureVersion=");
        b.append(this.signatureVersion);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
