package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalInformationUrl", 
    "detectionCount", 
    "deviceDeleted", 
    "initialDetectionDateTime", 
    "lastRefreshedDateTime", 
    "lastStateChangeDateTime", 
    "malwareCategory", 
    "malwareDisplayName", 
    "malwareExecutionState", 
    "malwareId", 
    "malwareSeverity", 
    "malwareThreatState", 
    "managedDeviceId", 
    "managedDeviceName", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class WindowsDeviceMalwareState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.windowsDeviceMalwareState";
    }

    @JsonProperty("additionalInformationUrl")
    protected String additionalInformationUrl;

    @JsonProperty("detectionCount")
    protected Integer detectionCount;

    @JsonProperty("deviceDeleted")
    protected Boolean deviceDeleted;

    @JsonProperty("initialDetectionDateTime")
    protected OffsetDateTime initialDetectionDateTime;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("lastStateChangeDateTime")
    protected OffsetDateTime lastStateChangeDateTime;

    @JsonProperty("malwareCategory")
    protected String malwareCategory;

    @JsonProperty("malwareDisplayName")
    protected String malwareDisplayName;

    @JsonProperty("malwareExecutionState")
    protected String malwareExecutionState;

    @JsonProperty("malwareId")
    protected String malwareId;

    @JsonProperty("malwareSeverity")
    protected String malwareSeverity;

    @JsonProperty("malwareThreatState")
    protected String malwareThreatState;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected WindowsDeviceMalwareState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDeviceMalwareState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String additionalInformationUrl;
        private Integer detectionCount;
        private Boolean deviceDeleted;
        private OffsetDateTime initialDetectionDateTime;
        private OffsetDateTime lastRefreshedDateTime;
        private OffsetDateTime lastStateChangeDateTime;
        private String malwareCategory;
        private String malwareDisplayName;
        private String malwareExecutionState;
        private String malwareId;
        private String malwareSeverity;
        private String malwareThreatState;
        private String managedDeviceId;
        private String managedDeviceName;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder additionalInformationUrl(String additionalInformationUrl) {
            this.additionalInformationUrl = additionalInformationUrl;
            this.changedFields = changedFields.add("additionalInformationUrl");
            return this;
        }

        public Builder detectionCount(Integer detectionCount) {
            this.detectionCount = detectionCount;
            this.changedFields = changedFields.add("detectionCount");
            return this;
        }

        public Builder deviceDeleted(Boolean deviceDeleted) {
            this.deviceDeleted = deviceDeleted;
            this.changedFields = changedFields.add("deviceDeleted");
            return this;
        }

        public Builder initialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
            this.initialDetectionDateTime = initialDetectionDateTime;
            this.changedFields = changedFields.add("initialDetectionDateTime");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder lastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
            this.lastStateChangeDateTime = lastStateChangeDateTime;
            this.changedFields = changedFields.add("lastStateChangeDateTime");
            return this;
        }

        public Builder malwareCategory(String malwareCategory) {
            this.malwareCategory = malwareCategory;
            this.changedFields = changedFields.add("malwareCategory");
            return this;
        }

        public Builder malwareDisplayName(String malwareDisplayName) {
            this.malwareDisplayName = malwareDisplayName;
            this.changedFields = changedFields.add("malwareDisplayName");
            return this;
        }

        public Builder malwareExecutionState(String malwareExecutionState) {
            this.malwareExecutionState = malwareExecutionState;
            this.changedFields = changedFields.add("malwareExecutionState");
            return this;
        }

        public Builder malwareId(String malwareId) {
            this.malwareId = malwareId;
            this.changedFields = changedFields.add("malwareId");
            return this;
        }

        public Builder malwareSeverity(String malwareSeverity) {
            this.malwareSeverity = malwareSeverity;
            this.changedFields = changedFields.add("malwareSeverity");
            return this;
        }

        public Builder malwareThreatState(String malwareThreatState) {
            this.malwareThreatState = malwareThreatState;
            this.changedFields = changedFields.add("malwareThreatState");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public WindowsDeviceMalwareState build() {
            WindowsDeviceMalwareState _x = new WindowsDeviceMalwareState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.windowsDeviceMalwareState";
            _x.id = id;
            _x.additionalInformationUrl = additionalInformationUrl;
            _x.detectionCount = detectionCount;
            _x.deviceDeleted = deviceDeleted;
            _x.initialDetectionDateTime = initialDetectionDateTime;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.lastStateChangeDateTime = lastStateChangeDateTime;
            _x.malwareCategory = malwareCategory;
            _x.malwareDisplayName = malwareDisplayName;
            _x.malwareExecutionState = malwareExecutionState;
            _x.malwareId = malwareId;
            _x.malwareSeverity = malwareSeverity;
            _x.malwareThreatState = malwareThreatState;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="additionalInformationUrl")
    @JsonIgnore
    public Optional<String> getAdditionalInformationUrl() {
        return Optional.ofNullable(additionalInformationUrl);
    }

    public WindowsDeviceMalwareState withAdditionalInformationUrl(String additionalInformationUrl) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("additionalInformationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.additionalInformationUrl = additionalInformationUrl;
        return _x;
    }

    @Property(name="detectionCount")
    @JsonIgnore
    public Optional<Integer> getDetectionCount() {
        return Optional.ofNullable(detectionCount);
    }

    public WindowsDeviceMalwareState withDetectionCount(Integer detectionCount) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("detectionCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.detectionCount = detectionCount;
        return _x;
    }

    @Property(name="deviceDeleted")
    @JsonIgnore
    public Optional<Boolean> getDeviceDeleted() {
        return Optional.ofNullable(deviceDeleted);
    }

    public WindowsDeviceMalwareState withDeviceDeleted(Boolean deviceDeleted) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("deviceDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.deviceDeleted = deviceDeleted;
        return _x;
    }

    @Property(name="initialDetectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInitialDetectionDateTime() {
        return Optional.ofNullable(initialDetectionDateTime);
    }

    public WindowsDeviceMalwareState withInitialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("initialDetectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.initialDetectionDateTime = initialDetectionDateTime;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public WindowsDeviceMalwareState withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="lastStateChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateChangeDateTime() {
        return Optional.ofNullable(lastStateChangeDateTime);
    }

    public WindowsDeviceMalwareState withLastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("lastStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        return _x;
    }

    @Property(name="malwareCategory")
    @JsonIgnore
    public Optional<String> getMalwareCategory() {
        return Optional.ofNullable(malwareCategory);
    }

    public WindowsDeviceMalwareState withMalwareCategory(String malwareCategory) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareCategory = malwareCategory;
        return _x;
    }

    @Property(name="malwareDisplayName")
    @JsonIgnore
    public Optional<String> getMalwareDisplayName() {
        return Optional.ofNullable(malwareDisplayName);
    }

    public WindowsDeviceMalwareState withMalwareDisplayName(String malwareDisplayName) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareDisplayName = malwareDisplayName;
        return _x;
    }

    @Property(name="malwareExecutionState")
    @JsonIgnore
    public Optional<String> getMalwareExecutionState() {
        return Optional.ofNullable(malwareExecutionState);
    }

    public WindowsDeviceMalwareState withMalwareExecutionState(String malwareExecutionState) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareExecutionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareExecutionState = malwareExecutionState;
        return _x;
    }

    @Property(name="malwareId")
    @JsonIgnore
    public Optional<String> getMalwareId() {
        return Optional.ofNullable(malwareId);
    }

    public WindowsDeviceMalwareState withMalwareId(String malwareId) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareId = malwareId;
        return _x;
    }

    @Property(name="malwareSeverity")
    @JsonIgnore
    public Optional<String> getMalwareSeverity() {
        return Optional.ofNullable(malwareSeverity);
    }

    public WindowsDeviceMalwareState withMalwareSeverity(String malwareSeverity) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareSeverity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareSeverity = malwareSeverity;
        return _x;
    }

    @Property(name="malwareThreatState")
    @JsonIgnore
    public Optional<String> getMalwareThreatState() {
        return Optional.ofNullable(malwareThreatState);
    }

    public WindowsDeviceMalwareState withMalwareThreatState(String malwareThreatState) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("malwareThreatState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.malwareThreatState = malwareThreatState;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public WindowsDeviceMalwareState withManagedDeviceId(String managedDeviceId) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    public WindowsDeviceMalwareState withManagedDeviceName(String managedDeviceName) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public WindowsDeviceMalwareState withTenantDisplayName(String tenantDisplayName) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public WindowsDeviceMalwareState withTenantId(String tenantId) {
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.windowsDeviceMalwareState");
        _x.tenantId = tenantId;
        return _x;
    }

    public WindowsDeviceMalwareState withUnmappedField(String name, Object value) {
        WindowsDeviceMalwareState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeviceMalwareState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeviceMalwareState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDeviceMalwareState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDeviceMalwareState _copy() {
        WindowsDeviceMalwareState _x = new WindowsDeviceMalwareState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalInformationUrl = additionalInformationUrl;
        _x.detectionCount = detectionCount;
        _x.deviceDeleted = deviceDeleted;
        _x.initialDetectionDateTime = initialDetectionDateTime;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        _x.malwareCategory = malwareCategory;
        _x.malwareDisplayName = malwareDisplayName;
        _x.malwareExecutionState = malwareExecutionState;
        _x.malwareId = malwareId;
        _x.malwareSeverity = malwareSeverity;
        _x.malwareThreatState = malwareThreatState;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDeviceMalwareState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalInformationUrl=");
        b.append(this.additionalInformationUrl);
        b.append(", ");
        b.append("detectionCount=");
        b.append(this.detectionCount);
        b.append(", ");
        b.append("deviceDeleted=");
        b.append(this.deviceDeleted);
        b.append(", ");
        b.append("initialDetectionDateTime=");
        b.append(this.initialDetectionDateTime);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("lastStateChangeDateTime=");
        b.append(this.lastStateChangeDateTime);
        b.append(", ");
        b.append("malwareCategory=");
        b.append(this.malwareCategory);
        b.append(", ");
        b.append("malwareDisplayName=");
        b.append(this.malwareDisplayName);
        b.append(", ");
        b.append("malwareExecutionState=");
        b.append(this.malwareExecutionState);
        b.append(", ");
        b.append("malwareId=");
        b.append(this.malwareId);
        b.append(", ");
        b.append("malwareSeverity=");
        b.append(this.malwareSeverity);
        b.append(", ");
        b.append("malwareThreatState=");
        b.append(this.malwareThreatState);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
