package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.ManagementActionInfo;
import odata.msgraph.client.beta.managed.tenants.complex.ManagementIntentInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "allTenantsIncluded", 
    "displayName", 
    "managementActions", 
    "managementIntents", 
    "tenantIds"})
@JsonInclude(Include.NON_NULL)
public class TenantGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantGroup";
    }

    @JsonProperty("allTenantsIncluded")
    protected Boolean allTenantsIncluded;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("managementActions")
    protected List<ManagementActionInfo> managementActions;

    @JsonProperty("managementActions@nextLink")
    protected String managementActionsNextLink;

    @JsonProperty("managementIntents")
    protected List<ManagementIntentInfo> managementIntents;

    @JsonProperty("managementIntents@nextLink")
    protected String managementIntentsNextLink;

    @JsonProperty("tenantIds")
    protected List<String> tenantIds;

    @JsonProperty("tenantIds@nextLink")
    protected String tenantIdsNextLink;

    protected TenantGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean allTenantsIncluded;
        private String displayName;
        private List<ManagementActionInfo> managementActions;
        private String managementActionsNextLink;
        private List<ManagementIntentInfo> managementIntents;
        private String managementIntentsNextLink;
        private List<String> tenantIds;
        private String tenantIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allTenantsIncluded(Boolean allTenantsIncluded) {
            this.allTenantsIncluded = allTenantsIncluded;
            this.changedFields = changedFields.add("allTenantsIncluded");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder managementActions(List<ManagementActionInfo> managementActions) {
            this.managementActions = managementActions;
            this.changedFields = changedFields.add("managementActions");
            return this;
        }

        public Builder managementActions(ManagementActionInfo... managementActions) {
            return managementActions(Arrays.asList(managementActions));
        }

        public Builder managementActionsNextLink(String managementActionsNextLink) {
            this.managementActionsNextLink = managementActionsNextLink;
            this.changedFields = changedFields.add("managementActions");
            return this;
        }

        public Builder managementIntents(List<ManagementIntentInfo> managementIntents) {
            this.managementIntents = managementIntents;
            this.changedFields = changedFields.add("managementIntents");
            return this;
        }

        public Builder managementIntents(ManagementIntentInfo... managementIntents) {
            return managementIntents(Arrays.asList(managementIntents));
        }

        public Builder managementIntentsNextLink(String managementIntentsNextLink) {
            this.managementIntentsNextLink = managementIntentsNextLink;
            this.changedFields = changedFields.add("managementIntents");
            return this;
        }

        public Builder tenantIds(List<String> tenantIds) {
            this.tenantIds = tenantIds;
            this.changedFields = changedFields.add("tenantIds");
            return this;
        }

        public Builder tenantIds(String... tenantIds) {
            return tenantIds(Arrays.asList(tenantIds));
        }

        public Builder tenantIdsNextLink(String tenantIdsNextLink) {
            this.tenantIdsNextLink = tenantIdsNextLink;
            this.changedFields = changedFields.add("tenantIds");
            return this;
        }

        public TenantGroup build() {
            TenantGroup _x = new TenantGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantGroup";
            _x.id = id;
            _x.allTenantsIncluded = allTenantsIncluded;
            _x.displayName = displayName;
            _x.managementActions = managementActions;
            _x.managementActionsNextLink = managementActionsNextLink;
            _x.managementIntents = managementIntents;
            _x.managementIntentsNextLink = managementIntentsNextLink;
            _x.tenantIds = tenantIds;
            _x.tenantIdsNextLink = tenantIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allTenantsIncluded")
    @JsonIgnore
    public Optional<Boolean> getAllTenantsIncluded() {
        return Optional.ofNullable(allTenantsIncluded);
    }

    public TenantGroup withAllTenantsIncluded(Boolean allTenantsIncluded) {
        TenantGroup _x = _copy();
        _x.changedFields = changedFields.add("allTenantsIncluded");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantGroup");
        _x.allTenantsIncluded = allTenantsIncluded;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TenantGroup withDisplayName(String displayName) {
        TenantGroup _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantGroup");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="managementActions")
    @JsonIgnore
    public CollectionPage<ManagementActionInfo> getManagementActions() {
        return new CollectionPage<ManagementActionInfo>(contextPath, ManagementActionInfo.class, this.managementActions, Optional.ofNullable(managementActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantGroup withManagementActions(List<ManagementActionInfo> managementActions) {
        TenantGroup _x = _copy();
        _x.changedFields = changedFields.add("managementActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantGroup");
        _x.managementActions = managementActions;
        return _x;
    }

    @Property(name="managementActions")
    @JsonIgnore
    public CollectionPage<ManagementActionInfo> getManagementActions(HttpRequestOptions options) {
        return new CollectionPage<ManagementActionInfo>(contextPath, ManagementActionInfo.class, this.managementActions, Optional.ofNullable(managementActionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="managementIntents")
    @JsonIgnore
    public CollectionPage<ManagementIntentInfo> getManagementIntents() {
        return new CollectionPage<ManagementIntentInfo>(contextPath, ManagementIntentInfo.class, this.managementIntents, Optional.ofNullable(managementIntentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantGroup withManagementIntents(List<ManagementIntentInfo> managementIntents) {
        TenantGroup _x = _copy();
        _x.changedFields = changedFields.add("managementIntents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantGroup");
        _x.managementIntents = managementIntents;
        return _x;
    }

    @Property(name="managementIntents")
    @JsonIgnore
    public CollectionPage<ManagementIntentInfo> getManagementIntents(HttpRequestOptions options) {
        return new CollectionPage<ManagementIntentInfo>(contextPath, ManagementIntentInfo.class, this.managementIntents, Optional.ofNullable(managementIntentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="tenantIds")
    @JsonIgnore
    public CollectionPage<String> getTenantIds() {
        return new CollectionPage<String>(contextPath, String.class, this.tenantIds, Optional.ofNullable(tenantIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantGroup withTenantIds(List<String> tenantIds) {
        TenantGroup _x = _copy();
        _x.changedFields = changedFields.add("tenantIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantGroup");
        _x.tenantIds = tenantIds;
        return _x;
    }

    @Property(name="tenantIds")
    @JsonIgnore
    public CollectionPage<String> getTenantIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tenantIds, Optional.ofNullable(tenantIdsNextLink), Collections.emptyList(), options);
    }

    public TenantGroup withUnmappedField(String name, Object value) {
        TenantGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantGroup _copy() {
        TenantGroup _x = new TenantGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allTenantsIncluded = allTenantsIncluded;
        _x.displayName = displayName;
        _x.managementActions = managementActions;
        _x.managementIntents = managementIntents;
        _x.tenantIds = tenantIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allTenantsIncluded=");
        b.append(this.allTenantsIncluded);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("managementActions=");
        b.append(this.managementActions);
        b.append(", ");
        b.append("managementIntents=");
        b.append(this.managementIntents);
        b.append(", ");
        b.append("tenantIds=");
        b.append(this.tenantIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
