package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.TenantContactInformation;

@JsonPropertyOrder({
    "@odata.type", 
    "contacts", 
    "displayName", 
    "tenantId", 
    "website"})
@JsonInclude(Include.NON_NULL)
public class TenantCustomizedInformation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantCustomizedInformation";
    }

    @JsonProperty("contacts")
    protected List<TenantContactInformation> contacts;

    @JsonProperty("contacts@nextLink")
    protected String contactsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("website")
    protected String website;

    protected TenantCustomizedInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantCustomizedInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<TenantContactInformation> contacts;
        private String contactsNextLink;
        private String displayName;
        private String tenantId;
        private String website;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contacts(List<TenantContactInformation> contacts) {
            this.contacts = contacts;
            this.changedFields = changedFields.add("contacts");
            return this;
        }

        public Builder contacts(TenantContactInformation... contacts) {
            return contacts(Arrays.asList(contacts));
        }

        public Builder contactsNextLink(String contactsNextLink) {
            this.contactsNextLink = contactsNextLink;
            this.changedFields = changedFields.add("contacts");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder website(String website) {
            this.website = website;
            this.changedFields = changedFields.add("website");
            return this;
        }

        public TenantCustomizedInformation build() {
            TenantCustomizedInformation _x = new TenantCustomizedInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantCustomizedInformation";
            _x.id = id;
            _x.contacts = contacts;
            _x.contactsNextLink = contactsNextLink;
            _x.displayName = displayName;
            _x.tenantId = tenantId;
            _x.website = website;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contacts")
    @JsonIgnore
    public CollectionPage<TenantContactInformation> getContacts() {
        return new CollectionPage<TenantContactInformation>(contextPath, TenantContactInformation.class, this.contacts, Optional.ofNullable(contactsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantCustomizedInformation withContacts(List<TenantContactInformation> contacts) {
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = changedFields.add("contacts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantCustomizedInformation");
        _x.contacts = contacts;
        return _x;
    }

    @Property(name="contacts")
    @JsonIgnore
    public CollectionPage<TenantContactInformation> getContacts(HttpRequestOptions options) {
        return new CollectionPage<TenantContactInformation>(contextPath, TenantContactInformation.class, this.contacts, Optional.ofNullable(contactsNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TenantCustomizedInformation withDisplayName(String displayName) {
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantCustomizedInformation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public TenantCustomizedInformation withTenantId(String tenantId) {
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantCustomizedInformation");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="website")
    @JsonIgnore
    public Optional<String> getWebsite() {
        return Optional.ofNullable(website);
    }

    public TenantCustomizedInformation withWebsite(String website) {
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = changedFields.add("website");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantCustomizedInformation");
        _x.website = website;
        return _x;
    }

    public TenantCustomizedInformation withUnmappedField(String name, Object value) {
        TenantCustomizedInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantCustomizedInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantCustomizedInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantCustomizedInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantCustomizedInformation _copy() {
        TenantCustomizedInformation _x = new TenantCustomizedInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contacts = contacts;
        _x.displayName = displayName;
        _x.tenantId = tenantId;
        _x.website = website;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantCustomizedInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contacts=");
        b.append(this.contacts);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("website=");
        b.append(this.website);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
