package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.TenantContract;
import odata.msgraph.client.beta.managed.tenants.complex.TenantStatusInformation;

@JsonPropertyOrder({
    "@odata.type", 
    "contract", 
    "createdDateTime", 
    "displayName", 
    "lastUpdatedDateTime", 
    "tenantId", 
    "tenantStatusInformation"})
@JsonInclude(Include.NON_NULL)
public class Tenant extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenant";
    }

    @JsonProperty("contract")
    protected TenantContract contract;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("tenantStatusInformation")
    protected TenantStatusInformation tenantStatusInformation;

    protected Tenant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TenantContract contract;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime lastUpdatedDateTime;
        private String tenantId;
        private TenantStatusInformation tenantStatusInformation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contract(TenantContract contract) {
            this.contract = contract;
            this.changedFields = changedFields.add("contract");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder tenantStatusInformation(TenantStatusInformation tenantStatusInformation) {
            this.tenantStatusInformation = tenantStatusInformation;
            this.changedFields = changedFields.add("tenantStatusInformation");
            return this;
        }

        public Tenant build() {
            Tenant _x = new Tenant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenant";
            _x.id = id;
            _x.contract = contract;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.tenantId = tenantId;
            _x.tenantStatusInformation = tenantStatusInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contract")
    @JsonIgnore
    public Optional<TenantContract> getContract() {
        return Optional.ofNullable(contract);
    }

    public Tenant withContract(TenantContract contract) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("contract");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.contract = contract;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Tenant withCreatedDateTime(OffsetDateTime createdDateTime) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Tenant withDisplayName(String displayName) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public Tenant withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public Tenant withTenantId(String tenantId) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="tenantStatusInformation")
    @JsonIgnore
    public Optional<TenantStatusInformation> getTenantStatusInformation() {
        return Optional.ofNullable(tenantStatusInformation);
    }

    public Tenant withTenantStatusInformation(TenantStatusInformation tenantStatusInformation) {
        Tenant _x = _copy();
        _x.changedFields = changedFields.add("tenantStatusInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenant");
        _x.tenantStatusInformation = tenantStatusInformation;
        return _x;
    }

    public Tenant withUnmappedField(String name, Object value) {
        Tenant _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tenant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Tenant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tenant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Tenant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Tenant _copy() {
        Tenant _x = new Tenant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contract = contract;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.tenantId = tenantId;
        _x.tenantStatusInformation = tenantStatusInformation;
        return _x;
    }

    @Action(name = "offboardTenant")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Tenant> offboardTenant() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Tenant>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.offboardTenant"), Tenant.class, _parameters);
    }

    @Action(name = "resetTenantOnboardingStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Tenant> resetTenantOnboardingStatus() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Tenant>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.resetTenantOnboardingStatus"), Tenant.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tenant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contract=");
        b.append(this.contract);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("tenantStatusInformation=");
        b.append(this.tenantStatusInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
