package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ActionUrl;
import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepVersionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepVersionRequest;
import odata.msgraph.client.beta.managed.tenants.enums.ManagementCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "createdByUserId", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastActionByUserId", 
    "lastActionDateTime", 
    "portalLink", 
    "priority"})
@JsonInclude(Include.NON_NULL)
public class ManagementTemplateStep extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementTemplateStep";
    }

    @JsonProperty("category")
    protected ManagementCategory category;

    @JsonProperty("createdByUserId")
    protected String createdByUserId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastActionByUserId")
    protected String lastActionByUserId;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("portalLink")
    protected ActionUrl portalLink;

    @JsonProperty("priority")
    protected Integer priority;

    protected ManagementTemplateStep() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementTemplateStep() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ManagementCategory category;
        private String createdByUserId;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String lastActionByUserId;
        private OffsetDateTime lastActionDateTime;
        private ActionUrl portalLink;
        private Integer priority;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder category(ManagementCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder createdByUserId(String createdByUserId) {
            this.createdByUserId = createdByUserId;
            this.changedFields = changedFields.add("createdByUserId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastActionByUserId(String lastActionByUserId) {
            this.lastActionByUserId = lastActionByUserId;
            this.changedFields = changedFields.add("lastActionByUserId");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder portalLink(ActionUrl portalLink) {
            this.portalLink = portalLink;
            this.changedFields = changedFields.add("portalLink");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public ManagementTemplateStep build() {
            ManagementTemplateStep _x = new ManagementTemplateStep();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementTemplateStep";
            _x.id = id;
            _x.category = category;
            _x.createdByUserId = createdByUserId;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastActionByUserId = lastActionByUserId;
            _x.lastActionDateTime = lastActionDateTime;
            _x.portalLink = portalLink;
            _x.priority = priority;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ManagementCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ManagementTemplateStep withCategory(ManagementCategory category) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.category = category;
        return _x;
    }

    @Property(name="createdByUserId")
    @JsonIgnore
    public Optional<String> getCreatedByUserId() {
        return Optional.ofNullable(createdByUserId);
    }

    public ManagementTemplateStep withCreatedByUserId(String createdByUserId) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("createdByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.createdByUserId = createdByUserId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ManagementTemplateStep withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ManagementTemplateStep withDescription(String description) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagementTemplateStep withDisplayName(String displayName) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastActionByUserId")
    @JsonIgnore
    public Optional<String> getLastActionByUserId() {
        return Optional.ofNullable(lastActionByUserId);
    }

    public ManagementTemplateStep withLastActionByUserId(String lastActionByUserId) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("lastActionByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.lastActionByUserId = lastActionByUserId;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public ManagementTemplateStep withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="portalLink")
    @JsonIgnore
    public Optional<ActionUrl> getPortalLink() {
        return Optional.ofNullable(portalLink);
    }

    public ManagementTemplateStep withPortalLink(ActionUrl portalLink) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("portalLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.portalLink = portalLink;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public ManagementTemplateStep withPriority(Integer priority) {
        ManagementTemplateStep _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStep");
        _x.priority = priority;
        return _x;
    }

    public ManagementTemplateStep withUnmappedField(String name, Object value) {
        ManagementTemplateStep _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="acceptedVersion")
    @JsonIgnore
    public ManagementTemplateStepVersionRequest getAcceptedVersion() {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("acceptedVersion"), RequestHelper.getValue(unmappedFields, "acceptedVersion"));
    }

    @NavigationProperty(name="managementTemplate")
    @JsonIgnore
    public ManagementTemplateRequest getManagementTemplate() {
        return new ManagementTemplateRequest(contextPath.addSegment("managementTemplate"), RequestHelper.getValue(unmappedFields, "managementTemplate"));
    }

    @NavigationProperty(name="versions")
    @JsonIgnore
    public ManagementTemplateStepVersionCollectionRequest getVersions() {
        return new ManagementTemplateStepVersionCollectionRequest(
                        contextPath.addSegment("versions"), RequestHelper.getValue(unmappedFields, "versions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStep patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStep put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementTemplateStep _copy() {
        ManagementTemplateStep _x = new ManagementTemplateStep();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.category = category;
        _x.createdByUserId = createdByUserId;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastActionByUserId = lastActionByUserId;
        _x.lastActionDateTime = lastActionDateTime;
        _x.portalLink = portalLink;
        _x.priority = priority;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementTemplateStep[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdByUserId=");
        b.append(this.createdByUserId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastActionByUserId=");
        b.append(this.lastActionByUserId);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("portalLink=");
        b.append(this.portalLink);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
