package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ActionUrl;
import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.TemplateParameter;
import odata.msgraph.client.beta.managed.tenants.complex.WorkloadAction;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.enums.ManagementCategory;
import odata.msgraph.client.beta.managed.tenants.enums.ManagementProvider;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "createdByUserId", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "informationLinks", 
    "lastActionByUserId", 
    "lastActionDateTime", 
    "parameters", 
    "priority", 
    "provider", 
    "userImpact", 
    "version", 
    "workloadActions"})
@JsonInclude(Include.NON_NULL)
public class ManagementTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementTemplate";
    }

    @JsonProperty("category")
    protected ManagementCategory category;

    @JsonProperty("createdByUserId")
    protected String createdByUserId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("informationLinks")
    protected List<ActionUrl> informationLinks;

    @JsonProperty("informationLinks@nextLink")
    protected String informationLinksNextLink;

    @JsonProperty("lastActionByUserId")
    protected String lastActionByUserId;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("parameters")
    protected List<TemplateParameter> parameters;

    @JsonProperty("parameters@nextLink")
    protected String parametersNextLink;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("provider")
    protected ManagementProvider provider;

    @JsonProperty("userImpact")
    protected String userImpact;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("workloadActions")
    protected List<WorkloadAction> workloadActions;

    @JsonProperty("workloadActions@nextLink")
    protected String workloadActionsNextLink;

    protected ManagementTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ManagementCategory category;
        private String createdByUserId;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private List<ActionUrl> informationLinks;
        private String informationLinksNextLink;
        private String lastActionByUserId;
        private OffsetDateTime lastActionDateTime;
        private List<TemplateParameter> parameters;
        private String parametersNextLink;
        private Integer priority;
        private ManagementProvider provider;
        private String userImpact;
        private Integer version;
        private List<WorkloadAction> workloadActions;
        private String workloadActionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder category(ManagementCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder createdByUserId(String createdByUserId) {
            this.createdByUserId = createdByUserId;
            this.changedFields = changedFields.add("createdByUserId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationLinks(List<ActionUrl> informationLinks) {
            this.informationLinks = informationLinks;
            this.changedFields = changedFields.add("informationLinks");
            return this;
        }

        public Builder informationLinks(ActionUrl... informationLinks) {
            return informationLinks(Arrays.asList(informationLinks));
        }

        public Builder informationLinksNextLink(String informationLinksNextLink) {
            this.informationLinksNextLink = informationLinksNextLink;
            this.changedFields = changedFields.add("informationLinks");
            return this;
        }

        public Builder lastActionByUserId(String lastActionByUserId) {
            this.lastActionByUserId = lastActionByUserId;
            this.changedFields = changedFields.add("lastActionByUserId");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder parameters(List<TemplateParameter> parameters) {
            this.parameters = parameters;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder parameters(TemplateParameter... parameters) {
            return parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder provider(ManagementProvider provider) {
            this.provider = provider;
            this.changedFields = changedFields.add("provider");
            return this;
        }

        public Builder userImpact(String userImpact) {
            this.userImpact = userImpact;
            this.changedFields = changedFields.add("userImpact");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder workloadActions(List<WorkloadAction> workloadActions) {
            this.workloadActions = workloadActions;
            this.changedFields = changedFields.add("workloadActions");
            return this;
        }

        public Builder workloadActions(WorkloadAction... workloadActions) {
            return workloadActions(Arrays.asList(workloadActions));
        }

        public Builder workloadActionsNextLink(String workloadActionsNextLink) {
            this.workloadActionsNextLink = workloadActionsNextLink;
            this.changedFields = changedFields.add("workloadActions");
            return this;
        }

        public ManagementTemplate build() {
            ManagementTemplate _x = new ManagementTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementTemplate";
            _x.id = id;
            _x.category = category;
            _x.createdByUserId = createdByUserId;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.informationLinks = informationLinks;
            _x.informationLinksNextLink = informationLinksNextLink;
            _x.lastActionByUserId = lastActionByUserId;
            _x.lastActionDateTime = lastActionDateTime;
            _x.parameters = parameters;
            _x.parametersNextLink = parametersNextLink;
            _x.priority = priority;
            _x.provider = provider;
            _x.userImpact = userImpact;
            _x.version = version;
            _x.workloadActions = workloadActions;
            _x.workloadActionsNextLink = workloadActionsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ManagementCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ManagementTemplate withCategory(ManagementCategory category) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.category = category;
        return _x;
    }

    @Property(name="createdByUserId")
    @JsonIgnore
    public Optional<String> getCreatedByUserId() {
        return Optional.ofNullable(createdByUserId);
    }

    public ManagementTemplate withCreatedByUserId(String createdByUserId) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("createdByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.createdByUserId = createdByUserId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ManagementTemplate withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ManagementTemplate withDescription(String description) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagementTemplate withDisplayName(String displayName) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="informationLinks")
    @JsonIgnore
    public CollectionPage<ActionUrl> getInformationLinks() {
        return new CollectionPage<ActionUrl>(contextPath, ActionUrl.class, this.informationLinks, Optional.ofNullable(informationLinksNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementTemplate withInformationLinks(List<ActionUrl> informationLinks) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("informationLinks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.informationLinks = informationLinks;
        return _x;
    }

    @Property(name="informationLinks")
    @JsonIgnore
    public CollectionPage<ActionUrl> getInformationLinks(HttpRequestOptions options) {
        return new CollectionPage<ActionUrl>(contextPath, ActionUrl.class, this.informationLinks, Optional.ofNullable(informationLinksNextLink), Collections.emptyList(), options);
    }

    @Property(name="lastActionByUserId")
    @JsonIgnore
    public Optional<String> getLastActionByUserId() {
        return Optional.ofNullable(lastActionByUserId);
    }

    public ManagementTemplate withLastActionByUserId(String lastActionByUserId) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("lastActionByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.lastActionByUserId = lastActionByUserId;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public ManagementTemplate withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<TemplateParameter> getParameters() {
        return new CollectionPage<TemplateParameter>(contextPath, TemplateParameter.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementTemplate withParameters(List<TemplateParameter> parameters) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("parameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.parameters = parameters;
        return _x;
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<TemplateParameter> getParameters(HttpRequestOptions options) {
        return new CollectionPage<TemplateParameter>(contextPath, TemplateParameter.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), options);
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public ManagementTemplate withPriority(Integer priority) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.priority = priority;
        return _x;
    }

    @Property(name="provider")
    @JsonIgnore
    public Optional<ManagementProvider> getProvider() {
        return Optional.ofNullable(provider);
    }

    public ManagementTemplate withProvider(ManagementProvider provider) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("provider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.provider = provider;
        return _x;
    }

    @Property(name="userImpact")
    @JsonIgnore
    public Optional<String> getUserImpact() {
        return Optional.ofNullable(userImpact);
    }

    public ManagementTemplate withUserImpact(String userImpact) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("userImpact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.userImpact = userImpact;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public ManagementTemplate withVersion(Integer version) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.version = version;
        return _x;
    }

    @Property(name="workloadActions")
    @JsonIgnore
    public CollectionPage<WorkloadAction> getWorkloadActions() {
        return new CollectionPage<WorkloadAction>(contextPath, WorkloadAction.class, this.workloadActions, Optional.ofNullable(workloadActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementTemplate withWorkloadActions(List<WorkloadAction> workloadActions) {
        ManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("workloadActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplate");
        _x.workloadActions = workloadActions;
        return _x;
    }

    @Property(name="workloadActions")
    @JsonIgnore
    public CollectionPage<WorkloadAction> getWorkloadActions(HttpRequestOptions options) {
        return new CollectionPage<WorkloadAction>(contextPath, WorkloadAction.class, this.workloadActions, Optional.ofNullable(workloadActionsNextLink), Collections.emptyList(), options);
    }

    public ManagementTemplate withUnmappedField(String name, Object value) {
        ManagementTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="managementTemplateCollections")
    @JsonIgnore
    public ManagementTemplateCollectionCollectionRequest getManagementTemplateCollections() {
        return new ManagementTemplateCollectionCollectionRequest(
                        contextPath.addSegment("managementTemplateCollections"), RequestHelper.getValue(unmappedFields, "managementTemplateCollections"));
    }

    @NavigationProperty(name="managementTemplateSteps")
    @JsonIgnore
    public ManagementTemplateStepCollectionRequest getManagementTemplateSteps() {
        return new ManagementTemplateStepCollectionRequest(
                        contextPath.addSegment("managementTemplateSteps"), RequestHelper.getValue(unmappedFields, "managementTemplateSteps"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementTemplate _copy() {
        ManagementTemplate _x = new ManagementTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.category = category;
        _x.createdByUserId = createdByUserId;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.informationLinks = informationLinks;
        _x.lastActionByUserId = lastActionByUserId;
        _x.lastActionDateTime = lastActionDateTime;
        _x.parameters = parameters;
        _x.priority = priority;
        _x.provider = provider;
        _x.userImpact = userImpact;
        _x.version = version;
        _x.workloadActions = workloadActions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdByUserId=");
        b.append(this.createdByUserId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationLinks=");
        b.append(this.informationLinks);
        b.append(", ");
        b.append("lastActionByUserId=");
        b.append(this.lastActionByUserId);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("parameters=");
        b.append(this.parameters);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("provider=");
        b.append(this.provider);
        b.append(", ");
        b.append("userImpact=");
        b.append(this.userImpact);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("workloadActions=");
        b.append(this.workloadActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
