package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.ManagementActionDeploymentStatus;
import odata.msgraph.client.beta.managed.tenants.complex.WorkloadAction;
import odata.msgraph.client.beta.managed.tenants.enums.ManagementCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "description", 
    "displayName", 
    "referenceTemplateId", 
    "referenceTemplateVersion", 
    "workloadActions"})
@JsonInclude(Include.NON_NULL)
public class ManagementAction extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementAction";
    }

    @JsonProperty("category")
    protected ManagementCategory category;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("referenceTemplateId")
    protected String referenceTemplateId;

    @JsonProperty("referenceTemplateVersion")
    protected Integer referenceTemplateVersion;

    @JsonProperty("workloadActions")
    protected List<WorkloadAction> workloadActions;

    @JsonProperty("workloadActions@nextLink")
    protected String workloadActionsNextLink;

    protected ManagementAction() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementAction() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ManagementCategory category;
        private String description;
        private String displayName;
        private String referenceTemplateId;
        private Integer referenceTemplateVersion;
        private List<WorkloadAction> workloadActions;
        private String workloadActionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder category(ManagementCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder referenceTemplateId(String referenceTemplateId) {
            this.referenceTemplateId = referenceTemplateId;
            this.changedFields = changedFields.add("referenceTemplateId");
            return this;
        }

        public Builder referenceTemplateVersion(Integer referenceTemplateVersion) {
            this.referenceTemplateVersion = referenceTemplateVersion;
            this.changedFields = changedFields.add("referenceTemplateVersion");
            return this;
        }

        public Builder workloadActions(List<WorkloadAction> workloadActions) {
            this.workloadActions = workloadActions;
            this.changedFields = changedFields.add("workloadActions");
            return this;
        }

        public Builder workloadActions(WorkloadAction... workloadActions) {
            return workloadActions(Arrays.asList(workloadActions));
        }

        public Builder workloadActionsNextLink(String workloadActionsNextLink) {
            this.workloadActionsNextLink = workloadActionsNextLink;
            this.changedFields = changedFields.add("workloadActions");
            return this;
        }

        public ManagementAction build() {
            ManagementAction _x = new ManagementAction();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementAction";
            _x.id = id;
            _x.category = category;
            _x.description = description;
            _x.displayName = displayName;
            _x.referenceTemplateId = referenceTemplateId;
            _x.referenceTemplateVersion = referenceTemplateVersion;
            _x.workloadActions = workloadActions;
            _x.workloadActionsNextLink = workloadActionsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ManagementCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ManagementAction withCategory(ManagementCategory category) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.category = category;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ManagementAction withDescription(String description) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagementAction withDisplayName(String displayName) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="referenceTemplateId")
    @JsonIgnore
    public Optional<String> getReferenceTemplateId() {
        return Optional.ofNullable(referenceTemplateId);
    }

    public ManagementAction withReferenceTemplateId(String referenceTemplateId) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("referenceTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.referenceTemplateId = referenceTemplateId;
        return _x;
    }

    @Property(name="referenceTemplateVersion")
    @JsonIgnore
    public Optional<Integer> getReferenceTemplateVersion() {
        return Optional.ofNullable(referenceTemplateVersion);
    }

    public ManagementAction withReferenceTemplateVersion(Integer referenceTemplateVersion) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("referenceTemplateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.referenceTemplateVersion = referenceTemplateVersion;
        return _x;
    }

    @Property(name="workloadActions")
    @JsonIgnore
    public CollectionPage<WorkloadAction> getWorkloadActions() {
        return new CollectionPage<WorkloadAction>(contextPath, WorkloadAction.class, this.workloadActions, Optional.ofNullable(workloadActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementAction withWorkloadActions(List<WorkloadAction> workloadActions) {
        ManagementAction _x = _copy();
        _x.changedFields = changedFields.add("workloadActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementAction");
        _x.workloadActions = workloadActions;
        return _x;
    }

    @Property(name="workloadActions")
    @JsonIgnore
    public CollectionPage<WorkloadAction> getWorkloadActions(HttpRequestOptions options) {
        return new CollectionPage<WorkloadAction>(contextPath, WorkloadAction.class, this.workloadActions, Optional.ofNullable(workloadActionsNextLink), Collections.emptyList(), options);
    }

    public ManagementAction withUnmappedField(String name, Object value) {
        ManagementAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementAction patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementAction put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementAction _copy() {
        ManagementAction _x = new ManagementAction();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.category = category;
        _x.description = description;
        _x.displayName = displayName;
        _x.referenceTemplateId = referenceTemplateId;
        _x.referenceTemplateVersion = referenceTemplateVersion;
        _x.workloadActions = workloadActions;
        return _x;
    }

    @Action(name = "apply")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus> apply(String tenantId, String tenantGroupId, String managementTemplateId, Boolean includeAllUsers, List<String> includeGroups, List<String> excludeGroups) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("tenantGroupId", "Edm.String", Checks.checkIsAscii(tenantGroupId))
            .put("managementTemplateId", "Edm.String", Checks.checkIsAscii(managementTemplateId))
            .put("includeAllUsers", "Edm.Boolean", includeAllUsers)
            .put("includeGroups", "Collection(Edm.String)", Checks.checkIsAscii(includeGroups))
            .put("excludeGroups", "Collection(Edm.String)", Checks.checkIsAscii(excludeGroups))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ManagementActionDeploymentStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.apply"), ManagementActionDeploymentStatus.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementAction[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("referenceTemplateId=");
        b.append(this.referenceTemplateId);
        b.append(", ");
        b.append("referenceTemplateVersion=");
        b.append(this.referenceTemplateVersion);
        b.append(", ");
        b.append("workloadActions=");
        b.append(this.workloadActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
